/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.JpaJDKTimerService;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManagerFactory;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory;
import org.jbpm.persistence.processinstance.JPASignalManagerFactory;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class SingleSessionCommandServiceTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(SingleSessionCommandServiceTest.class);
    private HashMap<String, Object> context;
    private Environment env;

    public SingleSessionCommandServiceTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public void setUp() {
        String testMethodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testPersistenceWorkItems() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)kbase, (KieSessionConfiguration)config, this.env);
        Long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        logger.info("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    @Test
    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        this.setUp();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)kbase, (KieSessionConfiguration)config, this.env);
        Long sessionId = service.getSessionId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        logger.info("Started process instance {}", (Object)processInstance.getId());
        ut.commit();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        ut.commit();
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private Collection<KnowledgePackage> getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.addAll(packageBuilder.getKnowledgePackages());
        return list;
    }

    @Test
    public void testPersistenceSubProcess() {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        properties.setProperty("drools.timerService", JpaJDKTimerService.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        KnowledgeBase ruleBase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalKnowledgePackage pkg = this.getProcessSubProcess();
        ruleBase.addKnowledgePackages(Arrays.asList(pkg));
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)ruleBase, (KieSessionConfiguration)config, this.env);
        Long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.execute((Command)startProcessCommand);
        logger.info("Started process instance {}", (Object)processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)ruleBase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)ruleBase, (KieSessionConfiguration)config, this.env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)ruleBase, (KieSessionConfiguration)config, this.env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)subProcessInstance);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private InternalKnowledgePackage getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    public void testPersistenceTimer() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        config.setOption((KieSessionOption)TimerJobFactoryOption.get((String)TimerJobFactoryType.JPA.getId()));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)kbase, (KieSessionConfiguration)config, this.env);
        Long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        logger.info("Started process instance {}", (Object)processInstance.getId());
        Thread.sleep(500L);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        Thread.sleep(5000L);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("2000");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)packageBuilder.getPackage());
        return list;
    }

    @Test
    public void testPersistenceTimer2() throws Exception {
        this.setUp();
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", SingleSessionCommandService.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", JPAProcessInstanceManagerFactory.class.getName());
        properties.setProperty("drools.workItemManagerFactory", JPAWorkItemManagerFactory.class.getName());
        properties.setProperty("drools.processSignalManagerFactory", JPASignalManagerFactory.class.getName());
        SessionConfiguration config = new SessionConfiguration(properties);
        config.setOption((KieSessionOption)TimerJobFactoryOption.get((String)TimerJobFactoryType.JPA.getId()));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer2();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService((KieBase)kbase, (KieSessionConfiguration)config, this.env);
        Long sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        logger.info("Started process instance {}", (Object)processInstance.getId());
        Thread.sleep(2000L);
        service = new SingleSessionCommandService(sessionId, (KieBase)kbase, (KieSessionConfiguration)config, this.env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        Assert.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("0");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try { Thread.sleep(1000); } catch (Throwable t) {} System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)packageBuilder.getPackage());
        return list;
    }
}

