/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.util;

import com.arjuna.ats.jta.TransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    public static final String DROOLS_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa";
    public static final String DROOLS_LOCAL_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa.local";
    public static final String JBPM_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa";
    public static final String JBPM_LOCAL_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa.local";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static TestH2Server h2Server = new TestH2Server();
    private static Properties defaultProperties = null;
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, "jdbc/testDS1");
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, String dataSourceName) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        String jdbcUrl = dsProps.getProperty("url");
        String driverClass = dsProps.getProperty("driverClassName");
        boolean startH2TcpServer = false;
        if (jdbcUrl.matches("jdbc:h2:tcp:.*")) {
            startH2TcpServer = true;
        }
        PoolingDataSource ds1 = PersistenceUtil.setupPoolingDataSource(dsProps, dataSourceName, startH2TcpServer);
        if (driverClass.startsWith("org.h2")) {
            ds1.getDriverProperties().setProperty("url", jdbcUrl);
        }
        ds1.init();
        context.put(DATASOURCE, ds1);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        context.put("org.kie.api.persistence.jpa.EntityManagerFactory", emf);
        return context;
    }

    public static void cleanUp(Map<String, Object> context) {
        if (context != null) {
            Object ds1Object;
            Object emfObject = context.remove("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emfObject != null) {
                try {
                    EntityManagerFactory emf = (EntityManagerFactory)emfObject;
                    emf.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((ds1Object = context.remove(DATASOURCE)) != null) {
                try {
                    PoolingDataSource ds1 = (PoolingDataSource)ds1Object;
                    ds1.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static PoolingDataSource setupPoolingDataSource(Properties dsProps) {
        return PersistenceUtil.setupPoolingDataSource(dsProps, "jdbc/testDS1", true);
    }

    public static PoolingDataSource setupPoolingDataSource(Properties dsProps, String datasourceName, boolean startServer) {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName(datasourceName);
        pds.setClassName(dsProps.getProperty("className"));
        for (String propertyName : new String[]{"user", "password"}) {
            pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
        }
        String driverClass = dsProps.getProperty("driverClassName");
        if ((driverClass.startsWith("org.h2") || driverClass.startsWith("org.hsqldb")) && startServer) {
            h2Server.start();
        }
        PersistenceUtil.setDatabaseSpecificDataSourceProperties(pds, dsProps);
        return pds;
    }

    public static void setDatabaseSpecificDataSourceProperties(PoolingDataSource pds, Properties dsProps) {
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2") || driverClass.startsWith("org.hsqldb")) {
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else {
            pds.setClassName(dsProps.getProperty("className"));
            if (driverClass.startsWith("oracle")) {
                pds.getDriverProperties().put("driverType", "thin");
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
            } else if (driverClass.startsWith("com.ibm.db2")) {
                pds.getDriverProperties().put("databaseName", dsProps.getProperty("databaseName"));
                pds.getDriverProperties().put("driverType", "4");
                pds.getDriverProperties().put("serverName", dsProps.getProperty("serverName"));
                pds.getDriverProperties().put("portNumber", dsProps.getProperty("portNumber"));
                pds.getDriverProperties().put("currentSchema", dsProps.getProperty("defaultSchema"));
                pds.getDriverProperties().put("url", dsProps.getProperty("url"));
            } else if (driverClass.startsWith("com.microsoft")) {
                for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
                pds.getDriverProperties().put("selectMethod", "cursor");
                pds.getDriverProperties().put("InstanceName", "MSSQL01");
            } else if (driverClass.startsWith("com.mysql")) {
                for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else if (driverClass.startsWith("org.mariadb")) {
                for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else if (driverClass.startsWith("com.sybase")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("REQUEST_HA_SESSION", "false");
                pds.getDriverProperties().put("networkProtocol", "Tds");
            } else if (driverClass.startsWith("org.postgresql") || driverClass.startsWith("com.edb")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else {
                throw new RuntimeException("Unknown driver class: " + driverClass);
            }
        }
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/target/jbpm-test", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "16", "true"};
            Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String password;
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: {}", (Object)ioe.getMessage());
                logger.warn("Stacktrace:", (Throwable)ioe);
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty("password")) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static boolean useTransactions() {
        boolean useTransactions = false;
        String databaseDriverClassName = PersistenceUtil.getDatasourceProperties().getProperty("driverClassName");
        if (databaseDriverClassName.startsWith("org.postgresql") || databaseDriverClassName.startsWith("com.edb")) {
            useTransactions = true;
        }
        return useTransactions;
    }

    public static Object getValueOfField(String fieldname, Object source) {
        String sourceClassName = source.getClass().getSimpleName();
        Field field = null;
        try {
            field = source.getClass().getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        Assert.assertNotNull((String)("." + fieldname + " field is null!?!"), (Object)field);
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }

    public static Environment createEnvironment(Map<String, Object> context) {
        Environment env = EnvironmentFactory.newEnvironment();
        UserTransaction ut = (UserTransaction)context.get("org.kie.transaction.Transaction");
        if (ut != null) {
            env.set("org.kie.transaction.Transaction", (Object)ut);
        }
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManager.transactionManager());
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    public static KieSession createKieSessionFromKBase(KieBase kbase, Map<String, Object> context) {
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)defaultProps);
        ksconf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        return kbase.newKieSession(ksconf, PersistenceUtil.createEnvironment(context));
    }

    private static class TestH2Server {
        private Server realH2Server;

        private TestH2Server() {
        }

        public void start() {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
                    this.realH2Server = Server.createTcpServer((String[])new String[0]);
                    this.realH2Server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"target/jbpm-test", (boolean)true);
            super.finalize();
        }
    }
}

