/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import javax.transaction.UserTransaction;
import org.jbpm.persistence.correlation.CorrelationPropertyInfo;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKeyFactory;

public class CorrelationKeySizePersistenceTest
extends AbstractBaseTest {
    private HashMap<String, Object> context;
    private String correlationKey;

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.jbpm.persistence.jpa");
        this.correlationKey = "";
        for (int i = 0; i < 300; ++i) {
            this.correlationKey = this.correlationKey + i % 10;
        }
    }

    @After
    public void after() throws Exception {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        try {
            EntityManager em = emf.createEntityManager();
            em.createQuery("delete from CorrelationPropertyInfo").executeUpdate();
            em.createQuery("delete from CorrelationKeyInfo").executeUpdate();
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            Assert.fail((String)"Exception thrown while trying to cleanup correlation data.");
        }
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testCreateCorrelationPropertyInfo() throws Exception {
        EntityManager em;
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        try {
            em = emf.createEntityManager();
            em.persist((Object)factory.newCorrelationKey(this.correlationKey));
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            Assert.fail((String)"Exception thrown while trying to prepare correlation data.");
        }
        em = emf.createEntityManager();
        TypedQuery query = em.createQuery("SELECT o FROM CorrelationPropertyInfo o WHERE o.value = :ckey", CorrelationPropertyInfo.class);
        query.setParameter("ckey", (Object)this.correlationKey.substring(0, 255));
        List keyInfo = query.getResultList();
        em.close();
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertEquals((long)1L, (long)keyInfo.size());
    }
}

