/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jpa.hibernate;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypeTemplate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.sql.BinaryTypeDescriptor;
import org.hibernate.type.descriptor.sql.LongVarcharTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class PostgreSQLLobTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect();
        if (dialect instanceof PostgreSQL81Dialect) {
            if (Boolean.getBoolean("org.kie.persistence.postgresql.useBytea")) {
                typeContributions.contributeType((BasicType)new ByteaContributorType());
            }
            if (Boolean.getBoolean("org.kie.persistence.postgresql.useText")) {
                typeContributions.contributeType((BasicType)new TextContributorType());
            }
        }
    }

    public class TextContributorType
    extends StandardBasicTypeTemplate<String> {
        private static final long serialVersionUID = 1619875355308645967L;

        public TextContributorType() {
            super((SqlTypeDescriptor)LongVarcharTypeDescriptor.INSTANCE, (JavaTypeDescriptor)StringTypeDescriptor.INSTANCE, new String[]{StandardBasicTypes.MATERIALIZED_CLOB.getName()});
        }
    }

    public class ByteaContributorType
    extends StandardBasicTypeTemplate<byte[]> {
        private static final long serialVersionUID = 1619875355308645967L;

        public ByteaContributorType() {
            super((SqlTypeDescriptor)BinaryTypeDescriptor.INSTANCE, (JavaTypeDescriptor)PrimitiveByteArrayTypeDescriptor.INSTANCE, new String[]{StandardBasicTypes.MATERIALIZED_BLOB.getName()});
        }
    }
}

