/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;

public class DefaultRuntimeEnvironment
extends SimpleRuntimeEnvironment {
    private EntityManagerFactory emf;

    public DefaultRuntimeEnvironment() {
        this((EntityManagerFactory)null);
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf) {
        this(emf, (GlobalSchedulerService)new ThreadPoolSchedulerService(1));
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, GlobalSchedulerService globalSchedulerService) {
        super(new DefaultRegisterableItemsFactory());
        this.emf = emf;
        this.schedulerService = globalSchedulerService;
        this.init();
    }

    public void init() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
        this.addToEnvironment("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        this.mapper = new JPAMapper(this.emf);
        this.userGroupCallback = new MvelUserGroupCallbackImpl();
    }
}

