/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeImpl;
import org.jbpm.runtime.manager.impl.SynchronizedRuntimeImpl;
import org.kie.internal.runtime.manager.Context;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;

public class SingletonRuntimeManager
extends AbstractRuntimeManager {
    private Runtime singleton;
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;

    public SingletonRuntimeManager() {
        super(null, null);
    }

    public SingletonRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.identifier = identifier;
    }

    public void init() {
        String location = this.getLocation();
        Integer knownSessionId = this.getPersistedSessionId(location, this.identifier);
        if (knownSessionId > 0) {
            try {
                this.singleton = new SynchronizedRuntimeImpl(this.factory.findKieSessionById(knownSessionId), this.taskServiceFactory.newTaskService());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.singleton == null) {
            this.singleton = new SynchronizedRuntimeImpl(this.factory.newKieSession(), this.taskServiceFactory.newTaskService());
            this.persistSessionId(location, this.identifier, this.singleton.getKieSession().getId());
        }
        ((RuntimeImpl)this.singleton).setManager(this);
        this.registerItems(this.singleton);
    }

    public Runtime getRuntime(Context context) {
        return this.singleton;
    }

    public void disposeRuntime(Runtime runtime) {
    }

    @Override
    public void close() {
        super.close();
        if (this.singleton instanceof Disposable) {
            ((Disposable)this.singleton).dispose();
        }
        this.factory.close();
        this.singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPersistedSessionId(String location, String identifier) {
        File sessionIdStore = new File(location + File.separator + identifier + "-jbpmSessionId.ser");
        if (sessionIdStore.exists()) {
            Integer knownSessionId = null;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                fis = new FileInputStream(sessionIdStore);
                in = new ObjectInputStream(fis);
                knownSessionId = (Integer)in.readObject();
                int n = knownSessionId;
                return n;
            }
            catch (Exception e) {
                int n = 0;
                return n;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistSessionId(String location, String identifier, int ksessionId) {
        if (location == null) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(location + File.separator + identifier + "-jbpmSessionId.ser");
            out = new ObjectOutputStream(fos);
            out.writeObject(ksessionId);
            out.close();
        }
        catch (IOException ex) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String getLocation() {
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        return location;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }
}

