/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeImpl;
import org.kie.internal.runtime.manager.Context;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;

public class PerRequestRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Runtime> local = new ThreadLocal();

    public PerRequestRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
    }

    public Runtime getRuntime(Context context) {
        if (local.get() != null) {
            return local.get();
        }
        RuntimeImpl runtime = new RuntimeImpl(this.factory.newKieSession(), this.taskServiceFactory.newTaskService());
        runtime.setManager(this);
        this.registerDisposeCallback(runtime);
        this.registerItems(runtime);
        local.set(runtime);
        return runtime;
    }

    public void disposeRuntime(Runtime runtime) {
        block2: {
            local.set(null);
            try {
                runtime.getKieSession().destroy();
            }
            catch (Exception e) {
                if (!(runtime instanceof Disposable)) break block2;
                ((Disposable)runtime).dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.factory.close();
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }
}

