/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.RegisterableItemsFactory;

public class SimpleRegisterableItemsFactory
implements RegisterableItemsFactory {
    private Map<String, Class<? extends WorkItemHandler>> workItemHandlersClasses = new ConcurrentHashMap<String, Class<? extends WorkItemHandler>>();
    private List<Class<? extends ProcessEventListener>> processListeners = new CopyOnWriteArrayList<Class<? extends ProcessEventListener>>();
    private List<Class<? extends AgendaEventListener>> agendListeners = new CopyOnWriteArrayList<Class<? extends AgendaEventListener>>();
    private List<Class<? extends WorkingMemoryEventListener>> workingMemoryListeners = new CopyOnWriteArrayList<Class<? extends WorkingMemoryEventListener>>();

    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> handlers = new HashMap<String, WorkItemHandler>();
        for (Map.Entry<String, Class<? extends WorkItemHandler>> entry : this.workItemHandlersClasses.entrySet()) {
            WorkItemHandler handler = this.createInstance(entry.getValue(), runtime.getKieSession());
            if (handler == null) continue;
            handlers.put(entry.getKey(), handler);
        }
        return handlers;
    }

    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        ArrayList<ProcessEventListener> listeners = new ArrayList<ProcessEventListener>();
        for (Class<? extends ProcessEventListener> clazz : this.processListeners) {
            ProcessEventListener pListener = this.createInstance(clazz, runtime.getKieSession());
            if (pListener == null) continue;
            listeners.add(pListener);
        }
        return listeners;
    }

    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> listeners = new ArrayList<AgendaEventListener>();
        for (Class<? extends AgendaEventListener> clazz : this.agendListeners) {
            AgendaEventListener aListener = this.createInstance(clazz, runtime.getKieSession());
            if (aListener == null) continue;
            listeners.add(aListener);
        }
        return listeners;
    }

    public List<WorkingMemoryEventListener> getWorkingMemoryEventListeners(RuntimeEngine runtime) {
        ArrayList<WorkingMemoryEventListener> listeners = new ArrayList<WorkingMemoryEventListener>();
        for (Class<? extends WorkingMemoryEventListener> clazz : this.workingMemoryListeners) {
            WorkingMemoryEventListener wmListener = this.createInstance(clazz, runtime.getKieSession());
            if (wmListener == null) continue;
            listeners.add(wmListener);
        }
        return listeners;
    }

    public void addWorkItemHandler(String name, Class<? extends WorkItemHandler> clazz) {
        this.workItemHandlersClasses.put(name, clazz);
    }

    public void addProcessListener(Class<? extends ProcessEventListener> clazz) {
        this.processListeners.add(clazz);
    }

    public void addAgendaListener(Class<? extends AgendaEventListener> clazz) {
        this.agendListeners.add(clazz);
    }

    public void addWorkingMemoryListener(Class<? extends WorkingMemoryEventListener> clazz) {
        this.workingMemoryListeners.add(clazz);
    }

    protected <T> T createInstance(Class<T> clazz, KieSession ksession) {
        T instance = null;
        try {
            Constructor<T> constructor = clazz.getConstructor(KieSession.class);
            instance = constructor.newInstance(ksession);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (instance == null) {
            try {
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return instance;
    }
}

