/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import org.drools.core.command.Interceptor;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.OptimisticLockRetryInterceptor;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;

public class JPASessionFactory
implements SessionFactory {
    private RuntimeEnvironment environment;

    public JPASessionFactory(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public KieSession newKieSession() {
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.environment.getKieBase(), (KieSessionConfiguration)this.environment.getConfiguration(), (Environment)this.environment.getEnvironment());
        this.addInterceptors((KieSession)ksession);
        return ksession;
    }

    public KieSession findKieSessionById(Integer sessionId) {
        if (sessionId == null) {
            return null;
        }
        StatefulKnowledgeSession ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)this.environment.getKieBase(), (KieSessionConfiguration)this.environment.getConfiguration(), (Environment)this.environment.getEnvironment());
        this.addInterceptors((KieSession)ksession);
        return ksession;
    }

    public void close() {
    }

    protected void addInterceptors(KieSession ksession) {
        SingleSessionCommandService sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
        sscs.addInterceptor((Interceptor)new OptimisticLockRetryInterceptor());
    }
}

