/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.mapper;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.jbpm.runtime.manager.impl.jpa.ContextMappingInfo;
import org.jbpm.runtime.manager.impl.mapper.EnvironmentAwareProcessInstanceContext;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.manager.Context;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class JPAMapper
implements Mapper {
    private EntityManagerFactory emf;

    public JPAMapper(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void saveMapping(Context context, Integer ksessionId) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        em.persist((Object)new ContextMappingInfo(this.resolveContext(context, em).getContextId().toString(), ksessionId));
        if (!info.isShared()) {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findMapping(Context context) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        try {
            ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), em);
            if (contextMapping != null) {
                Integer n = contextMapping.getKsessionId();
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (!info.isShared()) {
                em.close();
            }
        }
    }

    public void removeMapping(Context context) {
        EntityManagerInfo info = this.getEntityManager(context);
        EntityManager em = info.getEntityManager();
        ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), em);
        if (contextMapping != null) {
            em.remove((Object)contextMapping);
        }
        if (!info.isShared()) {
            em.close();
        }
    }

    protected Context resolveContext(Context orig, EntityManager em) {
        if (orig instanceof CorrelationKeyContext) {
            return this.getProcessInstanceByCorrelationKey((CorrelationKey)orig.getContextId(), em);
        }
        return orig;
    }

    protected ContextMappingInfo findContextByContextId(Context context, EntityManager em) {
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByContextId").setParameter("contextId", (Object)context.getContextId().toString());
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            return contextMapping;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            return null;
        }
    }

    public Context getProcessInstanceByCorrelationKey(CorrelationKey correlationKey, EntityManager em) {
        Query processInstancesForEvent = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("elem_count", (Object)correlationKey.getProperties().size());
        ArrayList<Object> properties = new ArrayList<Object>();
        for (CorrelationProperty property : correlationKey.getProperties()) {
            properties.add(property.getValue());
        }
        processInstancesForEvent.setParameter("properties", properties);
        try {
            return ProcessInstanceIdContext.get((Long)((Long)processInstancesForEvent.getSingleResult()));
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findContextId(Integer ksessionId) {
        EntityManagerInfo info = this.getEntityManager(null);
        EntityManager em = info.getEntityManager();
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByKSessionId").setParameter("ksessionId", (Object)ksessionId);
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            String string = contextMapping.getContextId();
            return string;
        }
        catch (NoResultException e) {
            Object var5_8 = null;
            return var5_8;
        }
        catch (NonUniqueResultException e) {
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            if (!info.isShared()) {
                em.close();
            }
        }
    }

    private EntityManagerInfo getEntityManager(Context context) {
        Environment env = null;
        if (context instanceof EnvironmentAwareProcessInstanceContext) {
            env = ((EnvironmentAwareProcessInstanceContext)context).getEnvironment();
        }
        if (env != null) {
            EntityManager em = (EntityManager)env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (em != null) {
                return new EntityManagerInfo(em, true);
            }
            EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emf != null) {
                return new EntityManagerInfo(emf.createEntityManager(), false);
            }
        } else {
            return new EntityManagerInfo(this.emf.createEntityManager(), false);
        }
        throw new RuntimeException("Could not find EntityManager, both command-scoped EM and EMF in environment are null");
    }

    private class EntityManagerInfo {
        private EntityManager entityManager;
        private boolean shared;

        public EntityManagerInfo(EntityManager entityManager, boolean shared) {
            this.entityManager = entityManager;
            this.shared = shared;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public boolean isShared() {
            return this.shared;
        }
    }
}

