/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.tx;

import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.kie.api.runtime.manager.RuntimeEnvironment;

public class TransactionAwareSchedulerServiceInterceptor
extends DelegateSchedulerServiceInterceptor {
    private RuntimeEnvironment environment;

    public TransactionAwareSchedulerServiceInterceptor(RuntimeEnvironment environment, GlobalSchedulerService schedulerService) {
        super(schedulerService);
        this.environment = environment;
    }

    public final void internalSchedule(TimerJobInstance timerJobInstance) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            super.internalSchedule(timerJobInstance);
            return;
        }
        TransactionManager tm = this.getTransactionManager();
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new ScheduleTimerTransactionSynchronization(timerJobInstance, this.delegate));
            return;
        }
        super.internalSchedule(timerJobInstance);
    }

    protected boolean hasEnvironmentEntry(String name, Object value) {
        Object envEntry = this.environment.getEnvironment().get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }

    protected TransactionManager getTransactionManager() {
        TransactionManager tm = (TransactionManager)this.environment.getEnvironment().get("org.kie.transaction.TransactionManager");
        if (tm == null) {
            tm = new JtaTransactionManager(null, null, null);
        }
        return tm;
    }

    private class ScheduleTimerTransactionSynchronization
    extends OrderedTransactionSynchronization {
        private GlobalSchedulerService schedulerService;
        private TimerJobInstance timerJobInstance;

        ScheduleTimerTransactionSynchronization(TimerJobInstance timerJobInstance, GlobalSchedulerService schedulerService) {
            super(Integer.valueOf(5));
            this.timerJobInstance = timerJobInstance;
            this.schedulerService = schedulerService;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                this.schedulerService.internalSchedule(this.timerJobInstance);
            }
        }

        public int compareTo(OrderedTransactionSynchronization o) {
            if (o instanceof ScheduleTimerTransactionSynchronization) {
                if (this.timerJobInstance.equals(((ScheduleTimerTransactionSynchronization)o).timerJobInstance)) {
                    return 0;
                }
                return -1;
            }
            return super.compareTo(o);
        }
    }
}

