/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.concurrent;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.UserGroupCallback;

public class ConcurrentOperationsTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testExecuteProcessWithAsyncHandler() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addEnvironmentEntry("TRANSACTION_LOCK_ENABLED", (Object)true).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Log", new AsyncWorkItemHandler(runtime.getKieSession()));
                return handlers;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CustomTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("customtask");
        this.logger.debug("Started process, committing...");
        ut.commit();
        Thread.sleep(2000L);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testExecuteHumanTaskWithAsyncHandler() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addEnvironmentEntry("TRANSACTION_LOCK_ENABLED", (Object)true).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Log", new AsyncWorkItemHandler(runtime.getKieSession()));
                return handlers;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CustomAndHumanTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        ProcessInstance processInstance = ksession.startProcess("customandhumantask");
        this.logger.debug("Started process, committing...");
        TaskService taskService = runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        taskService.complete(taskId, "john", null);
        this.logger.debug("Task completed, committing...");
        ut.commit();
        ksession.fireAllRules();
        Thread.sleep(2000L);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    private class AsyncWorkItemHandler
    implements WorkItemHandler {
        private KieSession ksession;

        AsyncWorkItemHandler(KieSession ksession) {
            this.ksession = ksession;
        }

        public void executeWorkItem(final WorkItem workItem, WorkItemManager manager) {
            new Thread(){

                @Override
                public void run() {
                    ConcurrentOperationsTest.this.logger.debug("staring a thread....");
                    AsyncWorkItemHandler.this.ksession.insert((Object)"doing it async");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ConcurrentOperationsTest.this.logger.debug("Completing the work item");
                    AsyncWorkItemHandler.this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
                }
            }.start();
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

