/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class PerRequestRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testCreationOfSession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 0L ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)(sessionId + 1L), (long)ksession.getIdentifier());
        sessionId = ksession.getIdentifier();
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)(sessionId + 1L), (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        try {
            ksession.getIdentifier();
            Assert.fail((String)"Should fail as session manager was closed and with that it's session");
        }
        catch (IllegalStateException e) {
        }
        catch (UndeclaredThrowableException e) {
            TestUtil.checkDisposedSessionException(e);
        }
    }

    @Test
    public void testCreationOfSessionWithPeristence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)(sessionId + 1L), (long)ksession.getIdentifier());
        sessionId = ksession.getIdentifier();
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)(sessionId + 1L), (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        try {
            ksession.getIdentifier();
            Assert.fail((String)"Should fail as session manager was closed and with that it's session");
        }
        catch (IllegalStateException e) {
        }
        catch (UndeclaredThrowableException e) {
            TestUtil.checkDisposedSessionException(e);
        }
    }

    @Test
    public void testCreationOfSessionWithinTransaction() throws Exception {
        System.setProperty("jbpm.tm.jndi.lookup", "java:comp/UserTransaction");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        ut.commit();
        try {
            ksession.getIdentifier();
            Assert.fail((String)"Should fail as session manager was closed and with that it's session");
        }
        catch (IllegalStateException e) {
        }
        catch (UndeclaredThrowableException e) {
            TestUtil.checkDisposedSessionException(e);
        }
        System.clearProperty("jbpm.tm.jndi.lookup");
    }

    @Test
    public void testExecuteReusableSubprocess() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addEnvironmentEntry("RuntimeEngineEagerInit", (Object)"true").addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        logs = logService.findProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testCreationOfRuntimeManagerWithinTransaction() throws Exception {
        System.setProperty("jbpm.tm.jndi.lookup", "java:comp/UserTransaction");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("ScriptTask");
        ut.commit();
        System.clearProperty("jbpm.tm.jndi.lookup");
    }

    @Test
    public void testCreationOfSessionTaskServiceNotConfigured() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        try {
            runtime.getTaskService();
            Assert.fail((String)"Should fail as task service is not configured");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"TaskService was not configured", (Object)e.getMessage());
        }
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcessesWithPeristence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        AuditService auditService = runtime.getAuditService();
        List throwProcessLogs = auditService.findProcessInstances("com.sample.bpmn.hello");
        List catchProcessLogs = auditService.findProcessInstances("com.sample.bpmn.Second");
        Assert.assertNotNull((Object)throwProcessLogs);
        Assert.assertEquals((long)1L, (long)throwProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)throwProcessLogs.get(0)).getStatus().intValue());
        Assert.assertNotNull((Object)catchProcessLogs);
        Assert.assertEquals((long)1L, (long)catchProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)catchProcessLogs.get(0)).getStatus().intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcesses() {
        final HashMap processStates = new HashMap();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().persistence(false).userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                ArrayList<ProcessEventListener> listeners = new ArrayList<ProcessEventListener>();
                listeners.add((ProcessEventListener)new DefaultProcessEventListener(){

                    public void afterProcessCompleted(ProcessCompletedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        Assert.assertEquals((long)2L, (long)processStates.size());
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.hello"));
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.Second"));
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.hello")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.Second")).intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }
}

