/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.concurrent;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.OptimisticLockException;
import javax.transaction.UserTransaction;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.hibernate.StaleObjectStateException;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

@RunWith(value=Parameterized.class)
public class SessionTest
extends AbstractBaseTest {
    private long maxWaitTime = 60000L;
    private int nbThreadsProcess = 10;
    private int nbThreadsTask = 10;
    private int nbInvocations = 10;
    private transient int completedStart = 0;
    private transient int completedTask = 0;
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private boolean useLocking;

    public SessionTest(boolean locking) {
        this.useLocking = locking;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}};
        return Arrays.asList(data);
    }

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        this.pds.close();
        if (this.manager != null) {
            this.manager.close();
        }
    }

    @Test
    @Ignore
    public void testSingletonSessionMemory() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
            RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
            RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
            manager.disposeRuntimeEngine(runtime);
            manager.close();
            System.gc();
            Thread.sleep(100L);
            System.gc();
            this.logger.info("Used memory {}", (Object)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
    }

    @Test
    public void testSingletonSession() throws Exception {
        int i;
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        long startTimeStamp = System.currentTimeMillis();
        long maxEndTime = startTimeStamp + this.maxWaitTime;
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        this.completedStart = 0;
        for (i = 0; i < this.nbThreadsProcess; ++i) {
            new Thread(new StartProcessRunnable(this.manager, i)).start();
        }
        this.completedTask = 0;
        for (i = 0; i < this.nbThreadsTask; ++i) {
            new Thread(new CompleteTaskRunnable(this.manager, i)).start();
        }
        while (this.completedStart < this.nbThreadsProcess || this.completedTask < this.nbThreadsTask) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() <= maxEndTime) continue;
            Assert.fail((String)"Failure, did not finish in time most likely hanging");
        }
        Thread.sleep(1000L);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)(this.nbThreadsProcess * this.nbInvocations), (long)logs.size());
        this.logger.debug("Done");
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSession() throws Exception {
        int i;
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        long startTimeStamp = System.currentTimeMillis();
        long maxEndTime = startTimeStamp + this.maxWaitTime;
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        this.completedStart = 0;
        for (i = 0; i < this.nbThreadsProcess; ++i) {
            new StartProcessRunnable(this.manager, i).run();
        }
        this.completedTask = 0;
        for (i = 0; i < this.nbThreadsTask; ++i) {
            new Thread(new CompleteTaskRunnable(this.manager, i)).start();
        }
        while (this.completedStart < this.nbThreadsProcess || this.completedTask < this.nbThreadsTask) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() <= maxEndTime) continue;
            Assert.fail((String)"Failure, did not finish in time most likely hanging");
        }
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)(this.nbThreadsProcess * this.nbInvocations), (long)logs.size());
        this.logger.debug("Done");
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testSessionPerProcessInstance() throws Exception {
        int i;
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        long startTimeStamp = System.currentTimeMillis();
        long maxEndTime = startTimeStamp + this.maxWaitTime;
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        this.completedStart = 0;
        for (i = 0; i < this.nbThreadsProcess; ++i) {
            new StartProcessPerProcessInstanceRunnable(this.manager, i).run();
        }
        this.completedTask = 0;
        for (i = 0; i < this.nbThreadsTask; ++i) {
            new Thread(new CompleteTaskPerProcessInstanceRunnable(this.manager, i)).start();
        }
        while (this.completedStart < this.nbThreadsProcess || this.completedTask < this.nbThreadsTask) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() <= maxEndTime) continue;
            Assert.fail((String)"Failure, did not finish in time most likely hanging");
        }
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("com.sample.bpmn.hello");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)(this.nbThreadsProcess * this.nbInvocations), (long)logs.size());
        this.logger.debug("Done");
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSessionSuccess() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello", null);
        this.logger.debug("Started process instance {}", (Object)processInstance.getId());
        long workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        long taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        ut.commit();
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        List tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        runtime.getTaskService().start(taskId, "mary");
        runtime.getTaskService().complete(taskId, "mary", null);
        ut.commit();
        Assert.assertNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        processInstance = ksession.startProcess("com.sample.bpmn.hello", null);
        workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        this.logger.debug("Started process instance {}", (Object)processInstance.getId());
        ut.commit();
        Assert.assertNotNull((Object)ksession.getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        runtime.getTaskService().start(taskId, "mary");
        runtime.getTaskService().complete(taskId, "mary", null);
        ut.commit();
        Assert.assertNull((Object)ksession.getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSessionFail() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sample.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello", null);
        this.logger.debug("Started process instance {}", (Object)processInstance.getId());
        long workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        long taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        ut.rollback();
        this.logger.debug("Rolled back");
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        List tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        processInstance = runtime.getKieSession().startProcess("com.sample.bpmn.hello", null);
        workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        this.logger.debug("Started process instance {}", (Object)processInstance.getId());
        ut.commit();
        Assert.assertNotNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        runtime.getTaskService().start(taskId, "mary");
        runtime.getTaskService().complete(taskId, "mary", null);
        ut.rollback();
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        runtime.getTaskService().start(taskId, "mary");
        runtime.getTaskService().complete(taskId, "mary", null);
        ut.commit();
        Assert.assertNull((Object)runtime.getKieSession().getProcessInstance(processInstance.getId()));
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSessionFailBefore() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sampleFailBefore.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        try {
            ProcessInstance processInstance = runtime.getKieSession().startProcess("com.sample.bpmn.hello", null);
            Assert.fail((String)("Started process instance " + processInstance.getId()));
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSessionFailAfter() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sampleFailAfter.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ProcessInstance processInstance = runtime.getKieSession().startProcess("com.sample.bpmn.hello.fa", null);
        long workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        long taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        List tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        try {
            ut.begin();
            runtime.getTaskService().start(taskId, "mary");
            runtime.getTaskService().complete(taskId, "mary", null);
            Assert.fail((String)"Task completed");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            ut.rollback();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testNewSessionFailAfter2() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"sampleFailAfter.bpmn"), ResourceType.BPMN2).get();
        if (this.useLocking) {
            environment.getEnvironment().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ProcessInstance processInstance = runtime.getKieSession().startProcess("com.sample.bpmn.hello.fa", null);
        long workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
        long taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
        runtime.getTaskService().claim(taskId, "mary");
        runtime.getTaskService().start(taskId, "mary");
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.InProgress);
        List tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        try {
            runtime.getTaskService().complete(taskId, "mary", null);
            Assert.fail((String)"Task completed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartProcess(RuntimeEngine runtime) throws Exception {
        SingleSessionCommandService singleSessionCommandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)runtime.getKieSession()).getCommandService();
        synchronized (singleSessionCommandService) {
            UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            ut.begin();
            this.logger.debug("Starting process on ksession {}", (Object)runtime.getKieSession().getIdentifier());
            ProcessInstance processInstance = runtime.getKieSession().startProcess("com.sample.bpmn.hello", null);
            this.logger.debug("Started process instance {} on ksession {}", (Object)processInstance.getId(), (Object)runtime.getKieSession().getIdentifier());
            long workItemId = ((HumanTaskNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next()).getWorkItemId();
            long taskId = runtime.getTaskService().getTaskByWorkItemId(workItemId).getId();
            this.logger.debug("Created task {}", (Object)taskId);
            runtime.getTaskService().claim(taskId, "mary");
            ut.commit();
        }
    }

    private boolean testCompleteTask(RuntimeEngine runtime) throws InterruptedException, Exception {
        boolean result = false;
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        List tasks = null;
        tasks = runtime.getTaskService().getTasksOwnedByStatus("mary", statusses, "en-UK");
        if (tasks.isEmpty()) {
            this.logger.debug("Task thread found no tasks");
            Thread.sleep(1000L);
        } else {
            long taskId = ((TaskSummary)tasks.get(0)).getId();
            this.logger.debug("Completing task {}", (Object)taskId);
            boolean success = false;
            try {
                runtime.getTaskService().start(taskId, "mary");
                success = true;
            }
            catch (PermissionDeniedException e) {
                this.logger.debug("Task thread was too late for starting task {}", (Object)taskId);
            }
            catch (RuntimeException e) {
                if (this.isCausedByOptimisticLockingFailure(e)) {
                    this.logger.debug("Task thread got in conflict when starting task {}", (Object)taskId);
                }
                throw e;
            }
            if (success) {
                try {
                    runtime.getTaskService().complete(taskId, "mary", null);
                    this.logger.debug("Completed task {}", (Object)taskId);
                    result = true;
                }
                catch (RuntimeException e) {
                    if (this.isCausedByOptimisticLockingFailure(e)) {
                        this.logger.debug("Task thread got in conflict when completing task {}", (Object)taskId);
                    }
                    throw e;
                }
            }
        }
        return result;
    }

    private boolean testCompleteTaskByProcessInstance(RuntimeEngine runtime, long piId) throws InterruptedException, Exception {
        boolean result = false;
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        List tasks = null;
        tasks = runtime.getTaskService().getTasksByStatusByProcessInstanceId(piId, statusses, "en-UK");
        if (tasks.isEmpty()) {
            this.logger.debug("Task thread found no tasks");
            Thread.sleep(1000L);
        } else {
            long taskId = ((TaskSummary)tasks.get(0)).getId();
            this.logger.debug("Completing task {}", (Object)taskId);
            boolean success = false;
            try {
                runtime.getTaskService().start(taskId, "mary");
                success = true;
            }
            catch (PermissionDeniedException e) {
                this.logger.debug("Task thread was too late for starting task {}", (Object)taskId);
            }
            catch (RuntimeException e) {
                if (this.isCausedByOptimisticLockingFailure(e)) {
                    this.logger.debug("Task thread got in conflict when starting task {}", (Object)taskId);
                }
                throw e;
            }
            if (success) {
                runtime.getTaskService().complete(taskId, "mary", null);
                this.logger.debug("Completed task {}", (Object)taskId);
                result = true;
            }
        }
        return result;
    }

    protected boolean isCausedByOptimisticLockingFailure(Throwable throwable) {
        while (throwable != null) {
            if (OptimisticLockException.class.isAssignableFrom(throwable.getClass()) || StaleObjectStateException.class.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public class CompleteTaskPerProcessInstanceRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public CompleteTaskPerProcessInstanceRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < SessionTest.this.nbInvocations) {
                    long processInstanceId = SessionTest.this.nbInvocations * this.counter + 1 + i;
                    SessionTest.this.logger.trace("pi id {} counter {}", (Object)processInstanceId, (Object)this.counter);
                    RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                    boolean success = false;
                    success = SessionTest.this.testCompleteTaskByProcessInstance(runtime, processInstanceId);
                    this.manager.disposeRuntimeEngine(runtime);
                    if (!success) continue;
                    ++i;
                }
                SessionTest.this.completedTask++;
                SessionTest.this.logger.trace("Task thread {} completed", (Object)this.counter);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class StartProcessPerProcessInstanceRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public StartProcessPerProcessInstanceRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < SessionTest.this.nbInvocations; ++i) {
                    RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
                    SessionTest.this.logger.trace("Thread {} doing call {}", (Object)this.counter, (Object)i);
                    SessionTest.this.testStartProcess(runtime);
                    this.manager.disposeRuntimeEngine(runtime);
                }
                SessionTest.this.logger.trace("Process thread {} completed", (Object)this.counter);
                SessionTest.this.completedStart++;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class CompleteTaskRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public CompleteTaskRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < SessionTest.this.nbInvocations) {
                    RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
                    boolean success = SessionTest.this.testCompleteTask(runtime);
                    this.manager.disposeRuntimeEngine(runtime);
                    if (!success) continue;
                    ++i;
                }
                SessionTest.this.completedTask++;
                SessionTest.this.logger.trace("Task thread {} completed", (Object)this.counter);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class StartProcessRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public StartProcessRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < SessionTest.this.nbInvocations; ++i) {
                    RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
                    SessionTest.this.logger.trace("Thread {} doing call {}", (Object)this.counter, (Object)i);
                    SessionTest.this.testStartProcess(runtime);
                    this.manager.disposeRuntimeEngine(runtime);
                }
                SessionTest.this.logger.trace("Process thread {} completed", (Object)this.counter);
                SessionTest.this.completedStart++;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

