/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.migration;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.UserGroupCallback;

public class MigrationManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private EntityManagerFactory emf;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager managerV1;
    private RuntimeManager managerV2;
    private static final String DEPLOYMENT_ID_V1 = "managerV1";
    private static final String DEPLOYMENT_ID_V2 = "managerV2";
    private static final String USER_JOHN = "john";
    private static final String PROCESS_ID_V1 = "UserTask-1";
    private static final String PROCESS_ID_V2 = "UserTask-2";
    private static final String PROCESS_NAME_V1 = "User Task v1";
    private static final String PROCESS_NAME_V2 = "User Task v2";
    private static final String TASK_NAME_V1 = "Hello v1";
    private static final String TASK_NAME_V2 = "Hello v2";
    private static final String ADDTASKAFTERACTIVE_ID_V1 = "process-migration-testv1.AddTaskAfterActive";
    private static final String ADDTASKAFTERACTIVE_ID_V2 = "process-migration-testv2.AddTaskAfterActive";
    private static final String ADDTASKBEFOREACTIVE_ID_V1 = "process-migration-testv1.AddTaskBeforeActive";
    private static final String ADDTASKBEFOREACTIVE_ID_V2 = "process-migration-testv2.AddTaskBeforeActive";
    private static final String REMOVEACTIVETASK_ID_V1 = "process-migration-testv1.RemoveActiveTask";
    private static final String REMOVEACTIVETASK_ID_V2 = "process-migration-testv2.RemoveActiveTask";
    private static final String REMOVENONACTIVETASK_ID_V1 = "process-migration-testv1.RemoveNonActiveTask";
    private static final String REMOVENONACTIVETASK_ID_V2 = "process-migration-testv2.RemoveNonActiveTask";
    private static final String REPLACEACTIVETASK_ID_V1 = "process-migration-testv1.ReplaceActiveTask";
    private static final String REPLACEACTIVETASK_ID_V2 = "process-migration-testv2.ReplaceActiveTask";
    private static final String REMOVENONACTIVEBEFORETASK_ID_V1 = "process-migration-testv1.RemoveNonActiveBeforeTask";
    private static final String REMOVENONACTIVEBEFORETASK_ID_V2 = "process-migration-testv2.RemoveNonActiveBeforeTask";
    private JPAAuditLogService auditService;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty(USER_JOHN, "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.auditService = new JPAAuditLogService(this.emf);
    }

    @After
    public void teardown() {
        this.auditService.dispose();
        if (this.managerV1 != null) {
            this.managerV1.close();
        }
        if (this.managerV2 != null) {
            this.managerV2.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testMigrateUserTaskProcessInstance() {
        this.createRuntimeManagers("migration/v1/BPMN2-UserTask-v1.bpmn2", "migration/v2/BPMN2-UserTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(PROCESS_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)PROCESS_NAME_V1, (Object)log.getProcessName());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        TaskService taskService = runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(USER_JOHN, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)PROCESS_ID_V1, (Object)task.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)task.getDeploymentId());
        Assert.assertEquals((Object)TASK_NAME_V1, (Object)task.getName());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, PROCESS_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)PROCESS_NAME_V2, (Object)log.getProcessName());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        auditService.dispose();
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        taskService = runtime.getTaskService();
        tasks = taskService.getTasksAssignedAsPotentialOwner(USER_JOHN, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)PROCESS_ID_V2, (Object)task.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)task.getDeploymentId());
        Assert.assertEquals((Object)TASK_NAME_V2, (Object)task.getName());
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testMigrateUserTaskProcessInstanceWithNodeMapping() {
        this.createRuntimeManagers("migration/v1/BPMN2-UserTask-v1.bpmn2", "migration/v2/BPMN2-UserTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(PROCESS_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        TaskService taskService = runtime.getTaskService();
        TaskSummary task = this.getTask(taskService);
        this.managerV1.disposeRuntimeEngine(runtime);
        Assert.assertEquals((Object)PROCESS_ID_V1, (Object)task.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)task.getDeploymentId());
        Assert.assertEquals((Object)TASK_NAME_V1, (Object)task.getName());
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, PROCESS_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate(Collections.singletonMap("_2", "_2"));
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(PROCESS_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, PROCESS_ID_V2, pi1.getId(), TASK_NAME_V2);
        this.assertMigratedProcessInstance(PROCESS_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testMigrateUserTaskProcessInstanceWithRollback() {
        this.createRuntimeManagers("migration/v1/BPMN2-UserTask-v1.bpmn2", "migration/v2/BPMN2-UserTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(PROCESS_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, PROCESS_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = null;
        try {
            Map<String, Integer> erronousMapping = Collections.singletonMap("_2", 2);
            migrationManager.migrate(erronousMapping);
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isSuccessful());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        auditService.dispose();
    }

    @Test
    public void testAddTaskAfterActive() {
        this.createRuntimeManagers("migration/v1/AddTaskAfterActive-v1.bpmn2", "migration/v2/AddTaskAfterActive-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(ADDTASKAFTERACTIVE_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, ADDTASKAFTERACTIVE_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, ADDTASKAFTERACTIVE_ID_V2, pi1.getId(), "Active Task");
        this.managerV2.disposeRuntimeEngine(runtime);
        this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, ADDTASKAFTERACTIVE_ID_V2, pi1.getId(), "Added Task");
        this.assertMigratedProcessInstance(ADDTASKAFTERACTIVE_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testAddTaskBeforeActive() {
        String activeNodeId = "_18771A1A-9DB9-4CA1-8C2E-19DEE24A1776";
        String addedNodeId = "_94643E69-BD97-4E4A-8B4A-364FEB95CA3C";
        this.createRuntimeManagers("migration/v1/AddTaskBeforeActive-v1.bpmn2", "migration/v2/AddTaskBeforeActive-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(ADDTASKBEFOREACTIVE_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, ADDTASKBEFOREACTIVE_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate(Collections.singletonMap(activeNodeId, addedNodeId));
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(ADDTASKBEFOREACTIVE_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, ADDTASKBEFOREACTIVE_ID_V2, pi1.getId(), "Added Task");
        this.managerV2.disposeRuntimeEngine(runtime);
        this.assertMigratedProcessInstance(ADDTASKBEFOREACTIVE_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, ADDTASKBEFOREACTIVE_ID_V2, pi1.getId(), "Active Task");
        this.managerV2.disposeRuntimeEngine(runtime);
        this.assertMigratedProcessInstance(ADDTASKBEFOREACTIVE_ID_V2, pi1.getId(), 2);
    }

    @Test
    public void testRemoveActiveTask() {
        String activeNodeId = "_ECEDD1CE-7380-418C-B7A6-AF8ECB90B820";
        String nextNodeId = "_9EF3CAE0-D978-4E96-9C00-8A80082EB68E";
        this.createRuntimeManagers("migration/v1/RemoveActiveTask-v1.bpmn2", "migration/v2/RemoveActiveTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(REMOVEACTIVETASK_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, REMOVEACTIVETASK_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate(Collections.singletonMap(activeNodeId, nextNodeId));
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, REMOVEACTIVETASK_ID_V2, pi1.getId(), "Mapped Task");
        this.assertMigratedProcessInstance(REMOVEACTIVETASK_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testRemoveNonActiveTask() {
        this.createRuntimeManagers("migration/v1/RemoveNonActiveTask-v1.bpmn2", "migration/v2/RemoveNonActiveTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(REMOVENONACTIVETASK_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, REMOVENONACTIVETASK_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(REMOVENONACTIVETASK_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, REMOVENONACTIVETASK_ID_V2, pi1.getId(), "Active Task");
        this.assertMigratedProcessInstance(REMOVENONACTIVETASK_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testReplaceActiveTask() {
        String activeNodeId = "_E9140EE9-1B5A-46B1-871E-A735402B69F4";
        String replaceNodeId = "_9B25FCC5-C718-4941-A4AE-DD8D6E368F48";
        this.createRuntimeManagers("migration/v1/ReplaceActiveTask-v1.bpmn2", "migration/v2/ReplaceActiveTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(REPLACEACTIVETASK_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, REPLACEACTIVETASK_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate(Collections.singletonMap(activeNodeId, replaceNodeId));
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(REPLACEACTIVETASK_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, REPLACEACTIVETASK_ID_V2, pi1.getId(), "Mapped Task");
        this.assertMigratedProcessInstance(REPLACEACTIVETASK_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testRemoveNonActiveBeforeActiveTask() {
        this.createRuntimeManagers("migration/v1/RemoveNonActiveBeforeTask-v1.bpmn2", "migration/v2/RemoveNonActiveBeforeTask-v2.bpmn2");
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(REMOVENONACTIVEBEFORETASK_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.assertTaskAndComplete(runtime.getTaskService(), REMOVENONACTIVEBEFORETASK_ID_V1, pi1.getId(), "Active Task");
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, REMOVENONACTIVEBEFORETASK_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        this.assertMigratedProcessInstance(REMOVENONACTIVEBEFORETASK_ID_V2, pi1.getId(), 1);
        runtime = this.managerV2.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        this.assertMigratedTaskAndComplete(taskService, REMOVENONACTIVEBEFORETASK_ID_V2, pi1.getId(), "Non-active Task");
        this.assertMigratedProcessInstance(REMOVENONACTIVEBEFORETASK_ID_V2, pi1.getId(), 2);
        this.managerV2.disposeRuntimeEngine(runtime);
    }

    protected TaskSummary getTask(TaskService taskService) {
        List tasks = taskService.getTasksAssignedAsPotentialOwner(USER_JOHN, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        return task;
    }

    protected void assertTaskAndComplete(TaskService taskService, String processId, Long processInstanceId, String taskName) {
        List tasks = taskService.getTasksByStatusByProcessInstanceId(processInstanceId.longValue(), Arrays.asList(Status.Reserved), "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)processId, (Object)task.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)task.getDeploymentId());
        Assert.assertEquals((Object)taskName, (Object)task.getName());
        taskService.start(task.getId().longValue(), USER_JOHN);
        taskService.complete(task.getId().longValue(), USER_JOHN, null);
    }

    protected void assertMigratedTaskAndComplete(TaskService taskService, String processId, Long processInstanceId, String taskName) {
        List tasks = taskService.getTasksByStatusByProcessInstanceId(processInstanceId.longValue(), Arrays.asList(Status.Reserved), "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)processId, (Object)task.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)task.getDeploymentId());
        Assert.assertEquals((Object)taskName, (Object)task.getName());
        taskService.start(task.getId().longValue(), USER_JOHN);
        taskService.complete(task.getId().longValue(), USER_JOHN, null);
    }

    protected void assertMigratedProcessInstance(String processId, long processInstanceId, int status) {
        ProcessInstanceLog instance = this.auditService.findProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)processId, (Object)instance.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)instance.getExternalId());
        Assert.assertEquals((long)status, (long)instance.getStatus().intValue());
    }

    protected void createRuntimeManagers(String processV1, String processV2) {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV1), ResourceType.BPMN2).get();
        this.managerV1 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, DEPLOYMENT_ID_V1);
        RuntimeEnvironment environment2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV2), ResourceType.BPMN2).get();
        this.managerV2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, DEPLOYMENT_ID_V2);
    }
}

