/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.concurrent;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.List;
import java.util.Properties;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class EventHnadlingTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testRunMultiEventProcessPerRequestRuntimeManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPM2-MultiEventProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("signalbroadcast");
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        ksession.signalEvent("Message-Msg", null);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        ksession.signalEvent("signal", null);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
    }

    @Test
    public void testRunMultiEventProcessPerProcessInstanceRuntimeManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPM2-MultiEventProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("signalbroadcast");
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtime.getKieSession();
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        ksession.signalEvent("Message-Msg", null);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtime.getKieSession();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        ksession.signalEvent("signal", null);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtime.getKieSession();
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
    }

    @Test
    public void testRunMultiEventProcessSingletonRuntimeManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPM2-MultiEventProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("signalbroadcast");
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)0L, (long)tasks.size());
        ksession.signalEvent("Message-Msg", null);
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        ksession.signalEvent("signal", null);
        tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
    }
}

