/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

public class SignalScopedToRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private EntityManagerFactory emf;
    private RuntimeManager manager;
    private RuntimeManager manager2;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        if (this.manager2 != null) {
            this.manager2.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testSingletonRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testSignalEventScopedToOwningRuntimeManager();
    }

    @Test
    public void testPerProcessInstanceRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testSignalEventScopedToOwningRuntimeManager();
    }

    @Test
    public void testPerRequestRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testSignalEventScopedToOwningRuntimeManager();
    }

    private void testSignalEventScopedToOwningRuntimeManager() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance processInstance = ksession1.startProcess("IntermediateCatchEventWithRef");
        this.manager.disposeRuntimeEngine(runtime1);
        RuntimeEngine runtime2 = this.manager2.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        ProcessInstance processInstance2 = ksession2.startProcess("IntermediateCatchEventWithRef");
        this.manager2.disposeRuntimeEngine(runtime2);
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("Signal1", (Object)"first");
        this.manager.disposeRuntimeEngine(runtime1);
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog pi1Log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)pi1Log);
        Assert.assertEquals((long)2L, (long)pi1Log.getStatus().intValue());
        ProcessInstanceLog pi2Log = auditService.findProcessInstance(processInstance2.getId());
        Assert.assertNotNull((Object)pi2Log);
        Assert.assertEquals((long)1L, (long)pi2Log.getStatus().intValue());
        runtime2 = this.manager2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance2.getId()));
        ksession2 = runtime2.getKieSession();
        ksession2.signalEvent("Signal1", (Object)"second");
        this.manager2.disposeRuntimeEngine(runtime2);
        pi2Log = auditService.findProcessInstance(processInstance2.getId());
        Assert.assertNotNull((Object)pi2Log);
        Assert.assertEquals((long)2L, (long)pi2Log.getStatus().intValue());
        auditService.dispose();
        this.manager.close();
    }

    @Test
    public void testSingletonRuntimeManagerCompleteTaskViaWrongRuntimeManager() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testCompleteTaskViaWrongRuntimeManager();
    }

    @Test
    public void testPerProcessInstanceRuntimeManagerCompleteTaskViaWrongRuntimeManager() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testCompleteTaskViaWrongRuntimeManager();
    }

    @Test
    public void testPerRequestRuntimeManagerCompleteTaskViaWrongRuntimeManager() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEnvironment environment2 = this.createEnvironment();
        this.manager2 = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment2, "second");
        Assert.assertNotNull((Object)this.manager2);
        this.testCompleteTaskViaWrongRuntimeManager();
    }

    private void testCompleteTaskViaWrongRuntimeManager() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance processInstance = ksession1.startProcess("UserTask");
        this.manager.disposeRuntimeEngine(runtime1);
        RuntimeEngine runtime2 = this.manager2.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        ProcessInstance processInstance2 = ksession2.startProcess("UserTask");
        this.manager2.disposeRuntimeEngine(runtime2);
        runtime2 = this.manager2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance2.getId()));
        List tasks1 = runtime2.getTaskService().getTasksByProcessInstanceId(processInstance.getId());
        Assert.assertEquals((long)1L, (long)tasks1.size());
        long task1Id = (Long)tasks1.get(0);
        try {
            runtime2.getTaskService().start(task1Id, "john");
            runtime2.getTaskService().complete(task1Id, "john", null);
            Assert.fail((String)"Should not be allowed to complete task via wrong runtime manager");
        }
        catch (IllegalStateException re) {
            Assert.assertEquals((Object)("Task instance " + task1Id + " is owned by another deployment expected first found second"), (Object)re.getMessage());
        }
        this.manager2.disposeRuntimeEngine(runtime2);
        this.manager2.close();
    }

    private RuntimeEnvironment createEnvironment() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-IntermediateCatchEventSignalWithRef.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        return environment;
    }
}

