/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.factory.InMemorySessionFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

@RunWith(value=Parameterized.class)
public class InMemorySessionFactoryLeakTest
extends AbstractBaseTest {
    private String strategy;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    @Rule
    public TestName testName = new TestName();

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"singleton"}, {"request"}, {"processinstance"});
    }

    public InMemorySessionFactoryLeakTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.createRuntimeManager();
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
    }

    private void createRuntimeManager() {
        RuntimeEnvironment environment = this.createEnvironment();
        if ("singleton".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        } else if ("processinstance".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        } else if ("request".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        }
        Assert.assertNotNull((Object)this.manager);
    }

    @Test
    public void testInMemorySessionCleanup() {
        for (int i = 0; i < 20; ++i) {
            RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
            KieSession ksession = runtime.getKieSession();
            ProcessInstance pi = ksession.startProcess("ScriptTask");
            Assert.assertEquals((long)2L, (long)pi.getState());
            this.manager.disposeRuntimeEngine(runtime);
        }
        InMemorySessionFactory factory = (InMemorySessionFactory)((AbstractRuntimeManager)this.manager).getFactory();
        int expectedSessionsInFactory = this.getExpectedSessionsInFactory();
        Assert.assertEquals((long)expectedSessionsInFactory, (long)factory.getSessions().size());
    }

    private RuntimeEnvironment createEnvironment() {
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addConfiguration("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName()).addConfiguration("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName()).registerableItemsFactory((RegisterableItemsFactory)new SimpleRegisterableItemsFactory()).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2);
        return builder.get();
    }

    private int getExpectedSessionsInFactory() {
        if ("singleton".equals(this.strategy)) {
            return 1;
        }
        if ("processinstance".equals(this.strategy)) {
            return 0;
        }
        if ("request".equals(this.strategy)) {
            return 0;
        }
        throw new IllegalStateException("Not supported strategy " + this.strategy);
    }
}

