/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class PersistenceRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        this.manager.close();
        this.pds.close();
    }

    @Test
    public void testPerProcessInstanceManagerDestorySession() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        EntityManager em = emf.createEntityManager();
        List sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        runtime.getKieSession();
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)1L, (long)sessions.size());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getId());
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)1L, (long)sessions.size());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        this.manager.disposeRuntimeEngine(runtime);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        this.manager.close();
        emf.close();
    }

    @Test
    public void testPerRequestManagerDestorySession() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        EntityManager em = emf.createEntityManager();
        List sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        runtime.getKieSession();
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)1L, (long)sessions.size());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)1L, (long)sessions.size());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        this.manager.disposeRuntimeEngine(runtime);
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertEquals((long)0L, (long)sessions.size());
        this.manager.close();
        emf.close();
    }
}

