/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.rule;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jbpm.runtime.manager.rule.Account;
import org.jbpm.runtime.manager.rule.OrderDetails;
import org.jbpm.runtime.manager.rule.OrderEligibility;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class FireRulesWithListeneronRMTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private RuntimeManager manager;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        this.manager.close();
        this.pds.close();
    }

    @Test
    public void testCreationOfSessionWithPersistence() throws ParseException {
        String accountRule = "";
        accountRule = accountRule + "package org.kie.test\n";
        accountRule = accountRule + "import org.jbpm.runtime.manager.rule.Account\n";
        accountRule = accountRule + "rule \"Account Eligibility\"\n";
        accountRule = accountRule + "dialect \"java\" \n";
        accountRule = accountRule + "when\n";
        accountRule = accountRule + "$account:Account( getAccountStatus().equals(\"O\"))\n";
        accountRule = accountRule + "then\n";
        accountRule = accountRule + "$account.setAccountEligible(true);\n";
        accountRule = accountRule + "System.out.println(\" Account Eligibility Rule called - then part after changing value  \"+$account);\n";
        accountRule = accountRule + "end\n";
        accountRule = accountRule + "\n";
        String customerRule = "";
        customerRule = customerRule + "package org.kie.test\n";
        customerRule = customerRule + "import org.jbpm.runtime.manager.rule.OrderEligibility\n";
        customerRule = customerRule + "import function org.jbpm.runtime.manager.rule.OrderEligibilityCheck.dateDifference\n";
        customerRule = customerRule + "rule \"Customer Eligibility\"\n";
        customerRule = customerRule + "dialect \"java\" \n";
        customerRule = customerRule + "when\n";
        customerRule = customerRule + " $orderEligibility: OrderEligibility(dateDifference(getOrderDetails().getEndDate(), getOrderDetails().getStartDate()))\n";
        customerRule = customerRule + "then\n";
        customerRule = customerRule + " $orderEligibility.setOrderEligibile(true);\n";
        customerRule = customerRule + "System.out.println(\" Order Eligibility Rule called - then part after changing value  \"+ $orderEligibility);\n";
        customerRule = customerRule + "end\n";
        customerRule = customerRule + "\n";
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(ResourceFactory.newByteArrayResource((byte[])accountRule.getBytes()), ResourceType.DRL).addAsset(ResourceFactory.newByteArrayResource((byte[])customerRule.getBytes()), ResourceType.DRL).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Account accountOpen = new Account("O");
        Account accountClosed = new Account("C");
        FactHandle accountOpen_FH = ksession.insert((Object)accountOpen);
        FactHandle accountClosed_FH = ksession.insert((Object)accountClosed);
        SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        Date today = stdDateFormat.parse("2014/03/10");
        Date yesterday = stdDateFormat.parse("2014/03/09");
        Date lastYear = stdDateFormat.parse("2013/03/10");
        OrderDetails lastYearOrder = new OrderDetails(lastYear, today);
        OrderDetails thisYearOrder = new OrderDetails(yesterday, today);
        OrderEligibility lastYearEligibility = new OrderEligibility(lastYearOrder);
        OrderEligibility thisYearEligibility = new OrderEligibility(thisYearOrder);
        FactHandle lye_FH = ksession.insert((Object)lastYearEligibility);
        FactHandle tye_FH = ksession.insert((Object)thisYearEligibility);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)accountOpen.getAccountEligible());
        Assert.assertTrue((accountClosed.getAccountEligible() == false ? 1 : 0) != 0);
        ksession.delete(accountOpen_FH);
        ksession.delete(accountClosed_FH);
        Assert.assertTrue((boolean)lastYearEligibility.getOrderEligibile());
        Assert.assertTrue((thisYearEligibility.getOrderEligibile() == false ? 1 : 0) != 0);
        ksession.delete(lye_FH);
        ksession.delete(tye_FH);
        this.manager.close();
    }
}

