/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.CountDownProcessEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(loadDirectory="target/test-classes")
public class TimerInitFailureRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private EntityManagerFactory emf;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/failOnRuntimeManagerInitRules.btm")
    public void testPerProcessInstanceRuntimeManager() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Intermediate Catch Event 1", 1);
        RuntimeEnvironment environment = this.createEnvironment(countDownListener);
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("TimerInitFailure", params);
        Assert.assertEquals((long)1L, (long)pi.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi.getId()));
        runtime.getKieSession();
        TaskService taskService = runtime.getTaskService();
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)list.size());
        long taskId = ((TaskSummary)list.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        this.manager.disposeRuntimeEngine(runtime);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi.getId()));
            runtime.getTaskService();
            Assert.fail((String)"ProcessInstance should already be completed");
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    @BMScript(value="byteman-scripts/failOnRuntimeManagerInitRules.btm")
    public void testPerCaseRuntimeManager() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Intermediate Catch Event 1", 1);
        RuntimeEnvironment environment = this.createEnvironment(countDownListener);
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"CASE-001"));
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("TimerInitFailure", params);
        Assert.assertEquals((long)1L, (long)pi.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"CASE-001"));
        runtime.getKieSession();
        TaskService taskService = runtime.getTaskService();
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)list.size());
        long taskId = ((TaskSummary)list.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"CASE-001"));
        AuditService auditService = runtime.getAuditService();
        ProcessInstanceLog log = auditService.findProcessInstance(pi.getId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
        auditService.dispose();
        this.manager.disposeRuntimeEngine(runtime);
    }

    private RuntimeEnvironment createEnvironment(final CountDownProcessEventListener countDownListener) {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerInitFailure.bpmn2"), ResourceType.BPMN2).get();
        return environment;
    }
}

