/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.scanner.KieMavenRepository;

public class KjarRuntimeEnvironmentTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private static final String ARTIFACT_ID = "kjar-module";
    private static final String GROUP_ID = "org.jbpm.test";
    private static final String VERSION = "1.0.0-SNAPSHOT";

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("BPMN2-ScriptTask.bpmn2");
        processes.add("BPMN2-UserTask.bpmn2");
        processes.add("BPMN2-CustomTask.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((org.appformer.maven.support.ReleaseId)releaseId, kJar1, pom);
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testCustomTaskFromKjar() {
        KieServices ks = KieServices.Factory.get();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION)).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testScriptTaskFromKjar() {
        KieServices ks = KieServices.Factory.get();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION)).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testScriptTaskFromKjarUsingNamedKbaseKsession() {
        KieServices ks = KieServices.Factory.get();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), "defaultKieBase", "defaultKieSession").userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testUserTaskFromKjar() {
        KieServices ks = KieServices.Factory.get();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION)).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("UserTask", params);
        List tasks = engine.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        engine.getTaskService().start(taskId, "john");
        engine.getTaskService().complete(taskId, "john", null);
        processInstance = engine.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.disposeRuntimeEngine(engine);
    }

    @Test
    public void testScriptTaskFromKjarByName() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(GROUP_ID, ARTIFACT_ID, VERSION).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testScriptTaskFromKjarByNameNamedKbaseKsession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(GROUP_ID, ARTIFACT_ID, VERSION, "defaultKieBase", "defaultKieSession").userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testScriptTaskFromClasspathContainer() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newClasspathKmoduleDefaultBuilder().userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testScriptTaskFromClasspathContainerNamedKbaseKsession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newClasspathKmoduleDefaultBuilder("defaultKieBase", "defaultKieSession").userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("ScriptTask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testUserTaskFromKjarPPI() {
        KieServices ks = KieServices.Factory.get();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION)).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("UserTask", params);
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        List tasks = engine.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        engine.getTaskService().start(taskId, "john");
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        engine.getTaskService().complete(taskId, "john", null);
        this.manager.disposeRuntimeEngine(engine);
        try {
            engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            processInstance = engine.getKieSession().getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
            Assert.fail((String)"Should fail as process instance is already completed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(engine);
    }

    @Test
    public void testXStreamUnmarshalCustomObject() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, "xstream-test", VERSION);
        File kjar = new File("src/test/resources/kjar/jbpm-module.jar");
        File pom = new File("src/test/resources/kjar/pom.xml");
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((org.appformer.maven.support.ReleaseId)releaseId, kjar, pom);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("Rest", new WorkItemHandler(){

                    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                        HashMap<String, String> results = new HashMap<String, String>();
                        results.put("Result", "<pv207.finepayment.Client><exists>true</exists><name>Pavel</name></pv207.finepayment.Client>");
                        manager.completeWorkItem(workItem.getId(), results);
                    }

                    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                    }
                });
                return handlers;
            }
        }).userGroupCallback(this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap params = new HashMap();
        ProcessInstance processInstance = engine.getKieSession().startProcess("RESTTask.RestProcess", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        Object processClient = ((WorkflowProcessInstance)processInstance).getVariable("processClient");
        Assert.assertNotNull((Object)processClient);
        Assert.assertEquals((Object)"pv207.finepayment.Client", (Object)processClient.getClass().getName());
        Assert.assertEquals((Object)"Pavel", (Object)this.valueOf(processClient, "name"));
        Assert.assertEquals((Object)"true", (Object)this.valueOf(processClient, "exists"));
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources) {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        for (String resource : resources) {
            kfs.write("src/main/resources/KBase-test/" + resource, ResourceFactory.newClassPathResource((String)resource));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        if (!kieBuilder.buildAll().getResults().getMessages().isEmpty()) {
            for (Message message : kieBuilder.buildAll().getResults().getMessages()) {
                this.logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("defaultKieBase").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("defaultKieSession").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected Object valueOf(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }
}

