/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.runtime.manager.impl.deploy.AbstractDeploymentDescriptorTest;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class MvelResolverDeploymentDescriptorManagerTest
extends AbstractDeploymentDescriptorTest {
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0";
    private PoolingDataSource pds;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testDeploymentDescriptorFromKieContainer() throws IOException {
        HashMap<String, String> resources = new HashMap<String, String>();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        String kmoduleString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/kmodule-custom-wih.xml"), (String)"UTF-8");
        resources.put("src/main/resources/META-INF/kmodule.xml", kmoduleString);
        String processString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-CustomTask.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-CustomTask.bpmn2", processString);
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        Properties properties = new Properties();
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get()).getKieSession().startProcess("customtask");
    }
}

