/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.migration;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

@RunWith(value=Parameterized.class)
public class TimerMigrationManagerTest
extends AbstractBaseTest {
    private String strategy;
    private PoolingDataSource pds;
    private EntityManagerFactory emf;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager managerV1;
    private RuntimeManager managerV2;
    private static final String DEPLOYMENT_ID_V1 = "managerV1";
    private static final String DEPLOYMENT_ID_V2 = "managerV2";
    private static final String TIMER_ID_V1 = "Timer-V1";
    private static final String TIMER_ID_V2 = "Timer-V2";
    private static final String BOUNDARY_TIMER_ID_V1 = "TimerBoundaryEventV1";
    private static final String BOUNDARY_TIMER_ID_V2 = "TimerBoundaryEventV2";
    private static final String EVENT_SUBPROCESS_TIMER_ID_V1 = "BPMN2-EventSubprocessTimerV1";
    private static final String EVENT_SUBPROCESS_TIMER_ID_V2 = "BPMN2-EventSubprocessTimerV2";
    private static final String CYCLE_TIMER_ID_V1 = "CycleTimer-V1";
    private static final String CYCLE_TIMER_ID_V2 = "CycleTimer-V2";
    private static final String LOOP_TIMER_ID_V1 = "ProcessClaim.CheckDisruption-v1";
    private static final String LOOP_TIMER_ID_V2 = "ProcessClaim.CheckDisruption-v2";
    private JPAAuditLogService auditService;

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"singleton"}, {"processinstance"});
    }

    public TimerMigrationManagerTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.auditService = new JPAAuditLogService(this.emf);
    }

    @After
    public void teardown() {
        this.auditService.dispose();
        if (this.managerV1 != null) {
            this.managerV1.close();
        }
        if (this.managerV2 != null) {
            this.managerV2.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testMigrateTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("EventV2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-Timer-v1.bpmn2", "migration/v2/BPMN2-Timer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testMigrateBoundaryTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("GoodbyeV2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerBoundary-v1.bpmn2", "migration/v2/BPMN2-TimerBoundary-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(BOUNDARY_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, BOUNDARY_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testMigrateEventSubprocessTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 1 V2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-EventSubprocessTimer-v1.bpmn2", "migration/v2/BPMN2-EventSubprocessTimer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(EVENT_SUBPROCESS_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, EVENT_SUBPROCESS_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)3L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testMigrateTimerProcessInstanceRollback() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Event", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-Timer-v1.bpmn2", "migration/v2/BPMN2-Timer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = null;
        try {
            Map<String, Integer> erronousMapping = Collections.singletonMap("_3", 3);
            migrationManager.migrate(erronousMapping);
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=20000L)
    public void testMigrateTimerCycleProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("print smt", 2);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerCycle-v1.bpmn2", "migration/v2/BPMN2-TimerCycle-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Map<String, String> params = Collections.singletonMap("startTime", Instant.now().toString());
        ProcessInstance pi1 = ksession.startProcess(CYCLE_TIMER_ID_V1, params);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        countdownListener.waitTillCompleted();
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, CYCLE_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        runtime = this.managerV2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.signalEvent("endMe", null, pi1.getId());
        this.managerV2.disposeRuntimeEngine(runtime);
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=20000L)
    public void testMigrateTimerCycleProcessInstanceBeforeFirstTrigger() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("print smt", 3);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerCycle-v1.bpmn2", "migration/v2/BPMN2-TimerCycle-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Map<String, String> params = Collections.singletonMap("startTime", Instant.now().plusSeconds(3L).toString());
        ProcessInstance pi1 = ksession.startProcess(CYCLE_TIMER_ID_V1, params);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, CYCLE_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(3);
        countdownListener.waitTillCompleted();
        runtime = this.managerV2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.signalEvent("endMe", null, pi1.getId());
        this.managerV2.disposeRuntimeEngine(runtime);
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=40000L)
    public void testMigrateTimerWithLoopProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("3s timer", 1);
        this.createRuntimeManagers("migration/v1/CheckDisruption-v1.bpmn2", "migration/v2/CheckDisruption-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(LOOP_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        countdownListener.waitTillCompleted();
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, LOOP_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V2, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V1, LOOP_TIMER_ID_V1);
        migrationManager = new MigrationManager(migrationSpec);
        report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        runtime = this.managerV1.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        ksession.abortProcessInstance(pi1.getId());
        this.managerV1.disposeRuntimeEngine(runtime);
    }

    protected void createRuntimeManagers(String processV1, String processV2, final ProcessEventListener ... eventListeners) {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV1), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                for (ProcessEventListener lister : eventListeners) {
                    listeners.add(lister);
                }
                return listeners;
            }

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("MyTask", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        RuntimeEnvironment environment2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV2), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                for (ProcessEventListener lister : eventListeners) {
                    listeners.add(lister);
                }
                return listeners;
            }

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("MyTask", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        this.createRuntimeManager(environment, environment2);
    }

    private void createRuntimeManager(RuntimeEnvironment environment, RuntimeEnvironment environment2) {
        if ("singleton".equals(this.strategy)) {
            this.managerV1 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, DEPLOYMENT_ID_V1);
            this.managerV2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, DEPLOYMENT_ID_V2);
        } else if ("processinstance".equals(this.strategy)) {
            this.managerV1 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, DEPLOYMENT_ID_V1);
            this.managerV2 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment2, DEPLOYMENT_ID_V2);
        }
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
    }
}

