/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.jpa.OptimisticLockRetryInterceptor;
import org.drools.persistence.jta.TransactionLockInterceptor;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventLister;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.error.ExecutionErrorHandlerInterceptor;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

public class SingletonRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testCreationOfSession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 0L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        ksession = this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionWithPersistence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        ksession = this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testReCreationOfSessionWithPersistence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        ksession = this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.close();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        ksession = this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testCreationOfMultipleSingletonManagerWithPersistence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "manager1");
        Assert.assertNotNull((Object)manager);
        RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager.disposeRuntimeEngine(runtime);
        ksession = manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager.close();
        RuntimeManager manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "manager2");
        Assert.assertNotNull((Object)manager2);
        runtime = manager2.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 2L ? 1 : 0) != 0);
        runtime = manager2.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager2.disposeRuntimeEngine(runtime);
        ksession = manager2.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager2.close();
        manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "manager1");
        Assert.assertNotNull((Object)manager);
        runtime = manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager.disposeRuntimeEngine(runtime);
        ksession = manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager.close();
        manager2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "manager2");
        Assert.assertNotNull((Object)manager2);
        runtime = manager2.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 2L ? 1 : 0) != 0);
        runtime = manager2.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager2.disposeRuntimeEngine(runtime);
        ksession = manager2.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        manager2.close();
    }

    @Test
    public void testCreationOfDuplicatedManagers() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        try {
            RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
            Assert.fail((String)"Should fail as it's not allowed to have singleton manager with same identifier");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.manager.close();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
    }

    @Test
    public void testExecuteReusableSubprocess() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        logs = logService.findProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testBusinessRuleTask() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTask.drl"), ResourceType.DRL).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        ProcessInstance pi = ksession.createProcessInstance("BPMN2-BusinessRuleTask", null);
        ksession.insert((Object)pi);
        ksession.startProcessInstance(pi.getId());
        Assert.assertNull((Object)ksession.getProcessInstance(pi.getId()));
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testBusinessRuleTaskWithRuleAwareListener() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTask.drl"), ResourceType.DRL).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance pi = ksession.startProcess("BPMN2-BusinessRuleTask");
        Assert.assertNull((Object)ksession.getProcessInstance(pi.getId()));
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    @Ignore
    public void testCreationOfSessionProtectedDispose() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 0L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        ksession = this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        ksession.dispose();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionTaskServiceNotConfigured() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        try {
            runtime.getTaskService();
            Assert.fail((String)"Should fail as task service is not configured");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"TaskService was not configured", (Object)e.getMessage());
        }
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testBusinessRuleTaskWithGlobal() {
        final ArrayList list = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTaskWithGlobal.drl"), ResourceType.DRL).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, Object> getGlobals(RuntimeEngine runtime) {
                Map globals = super.getGlobals(runtime);
                globals.put("list", list);
                return globals;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long sessionId = ksession.getIdentifier();
        Assert.assertTrue((sessionId == 1L ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)sessionId, (long)ksession.getIdentifier());
        ProcessInstance pi = ksession.createProcessInstance("BPMN2-BusinessRuleTask", null);
        ksession.insert((Object)pi);
        ksession.startProcessInstance(pi.getId());
        Assert.assertNull((Object)ksession.getProcessInstance(pi.getId()));
        Assert.assertEquals((long)1L, (long)list.size());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("BPMN2-BusinessRuleTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcessesWithPeristence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        AuditService auditService = runtime.getAuditService();
        List throwProcessLogs = auditService.findProcessInstances("com.sample.bpmn.hello");
        List catchProcessLogs = auditService.findProcessInstances("com.sample.bpmn.Second");
        Assert.assertNotNull((Object)throwProcessLogs);
        Assert.assertEquals((long)1L, (long)throwProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)throwProcessLogs.get(0)).getStatus().intValue());
        Assert.assertNotNull((Object)catchProcessLogs);
        Assert.assertEquals((long)1L, (long)catchProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)catchProcessLogs.get(0)).getStatus().intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcesses() {
        final HashMap processStates = new HashMap();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().persistence(false).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                ArrayList<ProcessEventListener> listeners = new ArrayList<ProcessEventListener>();
                listeners.add((ProcessEventListener)new DefaultProcessEventListener(){

                    public void afterProcessCompleted(ProcessCompletedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        Assert.assertEquals((long)2L, (long)processStates.size());
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.hello"));
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.Second"));
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.hello")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.Second")).intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testSignalEventViaRuntimeManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2IntermediateThrowEventScope.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance processInstance = ksession1.startProcess("intermediate-event-scope");
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        ProcessInstance processInstance2 = ksession2.startProcess("intermediate-event-scope");
        List tasks1 = runtime1.getTaskService().getTasksByProcessInstanceId(processInstance.getId());
        Assert.assertNotNull((Object)tasks1);
        Assert.assertEquals((long)1L, (long)tasks1.size());
        List tasks2 = runtime1.getTaskService().getTasksByProcessInstanceId(processInstance2.getId());
        Assert.assertNotNull((Object)tasks2);
        Assert.assertEquals((long)1L, (long)tasks2.size());
        String data = "some data";
        runtime1.getTaskService().claim(((Long)tasks1.get(0)).longValue(), "john");
        runtime1.getTaskService().start(((Long)tasks1.get(0)).longValue(), "john");
        runtime1.getTaskService().complete(((Long)tasks1.get(0)).longValue(), "john", Collections.singletonMap("_output", data));
        AuditService auditService = runtime1.getAuditService();
        ProcessInstanceLog pi1Log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)pi1Log);
        Assert.assertEquals((long)2L, (long)pi1Log.getStatus().intValue());
        ProcessInstanceLog pi2Log = auditService.findProcessInstance(processInstance2.getId());
        Assert.assertNotNull((Object)pi2Log);
        Assert.assertEquals((long)1L, (long)pi2Log.getStatus().intValue());
        List nLogs = auditService.findNodeInstances(processInstance2.getId(), "_527AF0A7-D741-4062-9953-A05E51479C80");
        Assert.assertNotNull((Object)nLogs);
        Assert.assertEquals((long)2L, (long)nLogs.size());
        auditService.dispose();
        this.manager.disposeRuntimeEngine(runtime1);
        this.manager.disposeRuntimeEngine(runtime2);
        this.manager.close();
    }

    @Test
    public void testInterceptorAfterRollback() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithRollback.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("UserTaskWithRollback");
        ExecutableRunner commandService = ((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        Assert.assertEquals(PersistableRunner.class, commandService.getClass());
        ChainableRunner internalCommandService = ((PersistableRunner)commandService).getChainableRunner();
        Assert.assertEquals(ExecutionErrorHandlerInterceptor.class, internalCommandService.getClass());
        internalCommandService = (ChainableRunner)((ExecutionErrorHandlerInterceptor)internalCommandService).getNext();
        Assert.assertEquals(TransactionLockInterceptor.class, internalCommandService.getClass());
        TaskService taskService = runtime.getTaskService();
        List taskIds = taskService.getTasksByProcessInstanceId(processInstance.getId());
        taskService.start(((Long)taskIds.get(0)).longValue(), "john");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("output1", "rollback");
        try {
            taskService.complete(((Long)taskIds.get(0)).longValue(), "john", result);
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
            // empty catch block
        }
        result = new HashMap();
        result.put("output1", "ok");
        taskService.complete(((Long)taskIds.get(0)).longValue(), "john", result);
        internalCommandService = ((PersistableRunner)commandService).getChainableRunner();
        Assert.assertEquals(ExecutionErrorHandlerInterceptor.class, internalCommandService.getClass());
        internalCommandService = (ChainableRunner)((ExecutionErrorHandlerInterceptor)internalCommandService).getNext();
        Assert.assertEquals(TransactionLockInterceptor.class, internalCommandService.getClass());
        internalCommandService = (ChainableRunner)((TransactionLockInterceptor)internalCommandService).getNext();
        Assert.assertEquals(OptimisticLockRetryInterceptor.class, internalCommandService.getClass());
        internalCommandService = (ChainableRunner)((OptimisticLockRetryInterceptor)internalCommandService).getNext();
        Assert.assertEquals((Object)"org.drools.persistence.PersistableRunner$TransactionInterceptor", (Object)internalCommandService.getClass().getName());
        this.manager.close();
    }

    @Test
    public void testSignalEventWithDeactivate() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }

    @Test(timeout=10000L)
    public void testTimerStartWithDeactivate() {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerStart.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        countDownListener.waitTillCompleted();
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(2000L);
        runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        runtime1 = this.manager.getRuntimeEngine(EmptyContext.get());
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }
}

