/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SimpleRuntimeEnvironmentTest {
    @Mock
    KnowledgeBuilder kbuilder;
    @InjectMocks
    SimpleRuntimeEnvironment environment;

    @Before
    public void before() {
        this.environment = new SimpleRuntimeEnvironment();
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void addAssetCsvXlsTest() {
        ((KnowledgeBuilder)Mockito.doNothing().when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class), (ResourceConfiguration)Mockito.any(ResourceConfiguration.class));
        ((KnowledgeBuilder)Mockito.doThrow((Throwable)new IllegalStateException("CSV resource not handled correctly!")).when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class));
        Resource resource = ResourceFactory.newClassPathResource((String)"/data/resource.csv", this.getClass());
        this.environment.addAsset(resource, ResourceType.DTABLE);
        ((KnowledgeBuilder)Mockito.doThrow((Throwable)new IllegalStateException("XLS resource not handled correctly!")).when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class));
        resource = ResourceFactory.newClassPathResource((String)"/data/resource.xls", this.getClass());
        this.environment.addAsset(resource, ResourceType.DTABLE);
        ((KnowledgeBuilder)Mockito.doThrow((Throwable)new IllegalStateException("BPMN2 resource not handled correctly!")).when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class), (ResourceConfiguration)Mockito.any(ResourceConfiguration.class));
        ((KnowledgeBuilder)Mockito.doNothing().when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class));
        resource = ResourceFactory.newClassPathResource((String)"/data/resource.bpmn2", this.getClass());
        this.environment.addAsset(resource, ResourceType.BPMN2);
    }

    @Test
    public void addAssetCsvXlsReplaceConfigTest() {
        ArgumentCaptor resourceConfigCaptor = ArgumentCaptor.forClass(ResourceConfiguration.class);
        ((KnowledgeBuilder)Mockito.doThrow((Throwable)new IllegalStateException("XLS resource not handled correctly!")).when((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class));
        Resource resource = ResourceFactory.newClassPathResource((String)"/data/resource.xls", this.getClass());
        DecisionTableConfigurationImpl config = new DecisionTableConfigurationImpl();
        config.setInputType(DecisionTableInputType.CSV);
        String worksheetName = "test-worksheet-name";
        config.setWorksheetName(worksheetName);
        resource.setConfiguration((ResourceConfiguration)config);
        this.environment.addAsset(resource, ResourceType.DTABLE);
        ((KnowledgeBuilder)Mockito.verify((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class), (ResourceConfiguration)resourceConfigCaptor.capture());
        ResourceConfiguration replacedConfig = (ResourceConfiguration)resourceConfigCaptor.getValue();
        Assert.assertTrue((String)("Not a DecisionTableConfiguration, but a " + replacedConfig.getClass().getSimpleName()), (boolean)(replacedConfig instanceof DecisionTableConfiguration));
        Assert.assertEquals((String)"Incorrect file type", (Object)DecisionTableInputType.XLS, (Object)((DecisionTableConfiguration)replacedConfig).getInputType());
        Assert.assertEquals((String)"Worksheet name not preserved", (Object)worksheetName, (Object)((DecisionTableConfiguration)replacedConfig).getWorksheetName());
    }

    @Test
    public void addAssetXLSDtableWithOwnConfigTest() {
        Resource resource = ResourceFactory.newClassPathResource((String)"/data/resource.xls", this.getClass());
        DecisionTableConfigurationImpl config = new DecisionTableConfigurationImpl();
        config.setInputType(DecisionTableInputType.XLS);
        String worksheetName = "test-worksheet-name";
        config.setWorksheetName(worksheetName);
        resource.setConfiguration((ResourceConfiguration)config);
        this.environment.addAsset(resource, ResourceType.DTABLE);
        ((KnowledgeBuilder)Mockito.verify((Object)this.kbuilder)).add((Resource)Mockito.any(Resource.class), (ResourceType)Mockito.any(ResourceType.class));
    }
}

