/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.exception.TaskExecutionException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.UserGroupCallback;

@RunWith(value=Parameterized.class)
public class ExecutionErrorHandlingRuntimeManagerTest
extends AbstractBaseTest {
    private String strategy;
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private EntityManagerFactory emf;
    private RuntimeManager manager;
    @Rule
    public TestName testName = new TestName();

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"singleton"}, {"request"}, {"processinstance"}, {"case"});
    }

    public ExecutionErrorHandlingRuntimeManagerTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.createRuntimeManager();
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    private void createRuntimeManager() {
        RuntimeEnvironment environment = this.createEnvironment();
        if ("singleton".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        } else if ("processinstance".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        } else if ("request".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        } else if ("case".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment, "first");
        }
        Assert.assertNotNull((Object)this.manager);
    }

    @Test
    public void testBasicScriptFailure() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        try {
            ksession1.startProcess("BrokenScriptTask");
            Assert.fail((String)"Start process should fail due to broken script");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime1);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        ExecutionErrorStorage storage = errorManager.getStorage();
        List errors = storage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        this.assertExecutionError((ExecutionError)errors.get(0), "Process", "BrokenScriptTask", "Hello");
    }

    @Test
    public void testScriptFailureAfterUserTask() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance pi = ksession1.startProcess("UserTaskWithRollback");
        this.manager.disposeRuntimeEngine(runtime1);
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi.getId()));
        ksession1 = runtime1.getKieSession();
        TaskService taskService = runtime1.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("output1", "rollback");
        try {
            taskService.complete(taskId, "john", results);
            Assert.fail((String)"Complete task should fail due to broken script");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime1);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        ExecutionErrorStorage storage = errorManager.getStorage();
        List errors = storage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        this.assertExecutionError((ExecutionError)errors.get(0), "Process", "UserTaskWithRollback", "Script Task 1");
    }

    @Test
    public void testUserTaskFailure() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ksession1.startProcess("UserTaskWithRollback");
        TaskService taskService = runtime1.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        try {
            ((EventService)taskService).registerTaskEventListener((Object)new DefaultTaskEventListener(){

                public void afterTaskStartedEvent(TaskEvent event) {
                    throw new TaskExecutionException("On purpose");
                }
            });
            taskService.start(taskId, "john");
            Assert.fail((String)"Start task should fail due to broken script");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime1);
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        ExecutionErrorStorage storage = errorManager.getStorage();
        List errors = storage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        this.assertExecutionError((ExecutionError)errors.get(0), "Task", "UserTaskWithRollback", "Hello");
    }

    @Test
    public void testDataBaseFailureInMemoryStorage() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ksession1.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                ExecutionErrorHandlingRuntimeManagerTest.this.pds.close();
            }
        });
        try {
            ksession1.startProcess("UserTaskWithRollback");
            Assert.fail((String)"Start process should fail due to data base error");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int expectedErrors = 1;
        try {
            this.manager.disposeRuntimeEngine(runtime1);
        }
        catch (Exception e) {
            ++expectedErrors;
        }
        ExecutionErrorManager errorManager = ((AbstractRuntimeManager)this.manager).getExecutionErrorManager();
        ExecutionErrorStorage storage = errorManager.getStorage();
        List errors = storage.list(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)errors);
        Assert.assertEquals((long)expectedErrors, (long)errors.size());
        this.assertExecutionError((ExecutionError)errors.get(0), "DB", "UserTaskWithRollback", "Hello");
        if (expectedErrors == 2) {
            this.assertExecutionError((ExecutionError)errors.get(1), "DB", "UserTaskWithRollback", "Hello");
        }
    }

    private RuntimeEnvironment createEnvironment() {
        ExecutionErrorStorage storage = new ExecutionErrorStorage(){
            private List<ExecutionError> errors = new ArrayList<ExecutionError>();

            public ExecutionError store(ExecutionError error) {
                this.errors.add(error);
                return error;
            }

            public List<ExecutionError> listByProcessInstance(Long processInstanceId, Integer page, Integer pageSize) {
                return this.errors;
            }

            public List<ExecutionError> listByDeployment(String deploymentId, Integer page, Integer pageSize) {
                return this.errors;
            }

            public List<ExecutionError> listByActivity(String activityName, Integer page, Integer pageSize) {
                return this.errors;
            }

            public List<ExecutionError> list(Integer page, Integer pageSize) {
                return this.errors;
            }

            public ExecutionError get(String errorId) {
                return this.errors.stream().filter(err -> err.getErrorId().equals(errorId)).findFirst().get();
            }

            public void acknowledge(String user, String ... errorIds) {
                for (String errorId : errorIds) {
                    ExecutionError error = this.get(errorId);
                    error.setAcknowledged(true);
                    error.setAcknowledgedBy(user);
                    error.setAcknowledgedAt(new Date());
                }
            }
        };
        RuntimeEnvironmentBuilder environmentBuilder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BrokenScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTaskWithRollback.bpmn2"), ResourceType.BPMN2);
        if (this.testName.getMethodName().contains("InMemoryStorage")) {
            environmentBuilder.addEnvironmentEntry("ExecutionErrorStorage", (Object)storage);
        }
        return environmentBuilder.get();
    }

    private void assertExecutionError(ExecutionError error, String type, String processId, String activityName) {
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)type, (Object)error.getType());
        Assert.assertEquals((Object)processId, (Object)error.getProcessId());
        Assert.assertEquals((Object)activityName, (Object)error.getActivityName());
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)error.getDeploymentId());
        Assert.assertNotNull((Object)error.getError());
        Assert.assertNotNull((Object)error.getErrorMessage());
        Assert.assertNotNull((Object)error.getActivityId());
        Assert.assertNotNull((Object)error.getProcessInstanceId());
        Assert.assertNull((Object)error.getAcknowledgedAt());
        Assert.assertNull((Object)error.getAcknowledgedBy());
        Assert.assertFalse((boolean)error.isAcknowledged());
    }
}

