/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.command.impl.AbstractInterceptor;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.runtime.error.ExecutionErrorManager;

public class ExecutionErrorHandlerInterceptor
extends AbstractInterceptor {
    private static final ThreadLocal<AtomicInteger> invocationsCounter = new ThreadLocal();
    private ExecutionErrorManager executionErrorManager;

    public ExecutionErrorHandlerInterceptor(Environment env) {
        this.executionErrorManager = (ExecutionErrorManager)env.get("ExecutionErrorManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RequestContext execute(Executable executable, RequestContext ctx) {
        AtomicInteger counter = invocationsCounter.get();
        if (counter == null) {
            counter = new AtomicInteger(0);
            invocationsCounter.set(counter);
        }
        counter.incrementAndGet();
        try {
            RequestContext requestContext = this.internalExecute(executable, ctx);
            return requestContext;
        }
        finally {
            if (counter.decrementAndGet() == 0) {
                invocationsCounter.remove();
            }
        }
    }

    protected RequestContext internalExecute(Executable executable, RequestContext ctx) {
        try {
            this.executeNext(executable, (Context)ctx);
            return ctx;
        }
        catch (Throwable ex) {
            if (this.hasInterceptorInStack() || this.executionErrorManager == null) {
                throw ex;
            }
            this.executionErrorManager.getHandler().handle(ex);
            throw ex;
        }
    }

    protected boolean hasInterceptorInStack() {
        return invocationsCounter.get().get() > 1;
    }
}

