/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.SessionConfiguration;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.runtime.manager.impl.deploy.AbstractDeploymentDescriptorTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.PoolingDataSource;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

public class RuntimeManagerWithDescriptorTest
extends AbstractDeploymentDescriptorTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private static List<String> taskEvents;
    private static List<String> processEvents;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        taskEvents = new ArrayList<String>();
        processEvents = new ArrayList<String>();
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
        taskEvents = null;
        processEvents = null;
    }

    @Test
    public void testDeployWithDefaultDeploymentDescriptor() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test.dd", "kjar-with-dd", "1.0.0");
        String processString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-ScriptTask.bpmn2"), (String)"UTF-8");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/BPMN2-ScriptTask.bpmn2", processString);
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        InternalRuntimeManager internalManager = (InternalRuntimeManager)this.manager;
        DeploymentDescriptor descriptor = internalManager.getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        RegisterableItemsFactory factory = internalManager.getEnvironment().getRegisterableItemsFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof InternalRegisterableItemsFactory));
        Assert.assertNotNull((Object)((InternalRegisterableItemsFactory)factory).getRuntimeManager());
        String descriptorFromKjar = descriptor.toXml();
        DeploymentDescriptorManager ddManager = new DeploymentDescriptorManager();
        String defaultDescriptor = ddManager.getDefaultDescriptor().toXml();
        Assert.assertEquals((Object)defaultDescriptor, (Object)descriptorFromKjar);
    }

    @Test
    public void testDeployWithCustomDeploymentDescriptor() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test.dd", "-kjar-with-dd", "1.0.0");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.persistence.jpa");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_REQUEST).addGlobal(new NamedObjectModel("service", "java.util.ArrayList", new Object[0]));
        String processString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-ScriptTask.bpmn2"), (String)"UTF-8");
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/BPMN2-ScriptTask.bpmn2", processString);
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        String drl = "package org.jbpm; global java.util.List service; \trule \"Start Hello1\"\t  when\t  then\t    System.out.println(\"Hello\");\tend";
        resources.put("src/main/resources/simple.drl", drl);
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        InternalRuntimeManager internalManager = (InternalRuntimeManager)this.manager;
        RegisterableItemsFactory factory = internalManager.getEnvironment().getRegisterableItemsFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof InternalRegisterableItemsFactory));
        Assert.assertNotNull((Object)((InternalRegisterableItemsFactory)factory).getRuntimeManager());
        DeploymentDescriptor descriptor = internalManager.getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.persistence.jpa", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.persistence.jpa", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_REQUEST, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        Object service = engine.getKieSession().getGlobal("service");
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof ArrayList));
    }

    @Test
    public void testDeployWithFullCustomDeploymentDescriptor() throws Exception {
        HashMap<String, String> resources = new HashMap<String, String>();
        String scriptString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-ScriptTask.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-ScriptTask.bpmn2", scriptString);
        String manualString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-ManualTask.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-ManualTask.bpmn2", manualString);
        String userString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTask.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-UserTask.bpmn2", userString);
        String callString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-CallActivity.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-CallActivity.bpmn2", callString);
        String subProcessString = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-CallActivitySubProcess.bpmn2"), (String)"UTF-8");
        resources.put("src/main/resources/BPMN2-CallActivitySubProcess.bpmn2", subProcessString);
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.persistence.jpa");
        customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).addMarshalingStrategy(new ObjectModel("org.jbpm.runtime.manager.impl.deploy.RuntimeManagerWithDescriptorTest$TestMarshallingStrategy", new Object[0])).addConfiguration(new NamedObjectModel("drools.processSignalManagerFactory", "java.lang.String", new Object[]{DefaultSignalManagerFactory.class.getName()})).addEnvironmentEntry(new NamedObjectModel("jbpm.business.calendar", "org.jbpm.runtime.manager.impl.deploy.RuntimeManagerWithDescriptorTest$TestBusinessCalendar", new Object[0])).addEventListener(new ObjectModel("org.jbpm.runtime.manager.impl.deploy.RuntimeManagerWithDescriptorTest$TestProcessEventListener", new Object[0])).addGlobal(new NamedObjectModel("service", "java.util.ArrayList", new Object[0])).addTaskEventListener(new ObjectModel("org.jbpm.runtime.manager.impl.deploy.RuntimeManagerWithDescriptorTest$TestTaskEventListener", new Object[0])).addWorkItemHandler(new NamedObjectModel("Manual Task", "org.jbpm.runtime.manager.impl.deploy.RuntimeManagerWithDescriptorTest$TestWorkItemHandler", new Object[0]));
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        String drl = "package org.jbpm; global java.util.List service; \trule \"Start Hello1\"\t  when\t  then\t    System.out.println(\"Hello\");\tend";
        resources.put("src/main/resources/simple.drl", drl);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test.dd", "-kjar-with-dd", "1.0.0");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        InternalRuntimeManager internalManager = (InternalRuntimeManager)this.manager;
        RegisterableItemsFactory factory = internalManager.getEnvironment().getRegisterableItemsFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof InternalRegisterableItemsFactory));
        Assert.assertNotNull((Object)((InternalRegisterableItemsFactory)factory).getRuntimeManager());
        DeploymentDescriptor descriptor = internalManager.getDeploymentDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.persistence.jpa", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.persistence.jpa", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)1L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)1L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)1L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
        RuntimeEngine engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        Assert.assertNotNull((Object)engine);
        KieSession kieSession = engine.getKieSession();
        Assert.assertEquals((Object)((SessionConfiguration)kieSession.getSessionConfiguration()).getSignalManagerFactory(), (Object)DefaultSignalManagerFactory.class.getName());
        BusinessCalendar bc = (BusinessCalendar)kieSession.getEnvironment().get("jbpm.business.calendar");
        Assert.assertNotNull((Object)bc);
        Assert.assertTrue((boolean)(bc instanceof TestBusinessCalendar));
        Object service = kieSession.getGlobal("service");
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)(service instanceof ArrayList));
        ProcessInstance processInstance = kieSession.startProcess("ManualTask");
        long processInstanceId = processInstance.getId();
        Assert.assertNotNull((Object)kieSession.getProcessInstance(processInstanceId));
        kieSession.getWorkItemManager().completeWorkItem(TestWorkItemHandler.getWorkItem().getId(), null);
        Assert.assertNull((Object)kieSession.getProcessInstance(processInstanceId));
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        kieSession = engine.getKieSession();
        Assert.assertArrayEquals((Object[])new String[]{"beforeProcessStarted", "afterProcessStarted", "beforeProcessCompleted", "afterProcessCompleted"}, (Object[])processEvents.toArray());
        processEvents.clear();
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        kieSession = engine.getKieSession();
        processInstance = kieSession.startProcess("UserTask");
        processInstanceId = processInstance.getId();
        Assert.assertNotNull((Object)kieSession.getProcessInstance(processInstanceId));
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        TaskService taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        Assert.assertArrayEquals((Object[])new String[]{"beforeTaskAddedEvent", "afterTaskAddedEvent", "beforeTaskStartedEvent", "afterTaskStartedEvent", "beforeTaskCompletedEvent", "afterTaskCompletedEvent"}, (Object[])taskEvents.toArray());
        this.manager.disposeRuntimeEngine(engine);
        engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        kieSession = engine.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "marshal");
        processInstance = kieSession.startProcess("ParentProcess", params);
        processInstanceId = processInstance.getId();
        ProcessInstance pi = kieSession.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)pi);
        String varX = (String)((WorkflowProcessInstance)pi).getVariable("x");
        Assert.assertEquals((Object)"custom marshaller invoked", (Object)varX);
        this.manager.disposeRuntimeEngine(engine);
    }

    public static class TestBusinessCalendar
    implements BusinessCalendar {
        public long calculateBusinessTimeAsDuration(String timeExpression) {
            return 0L;
        }

        public Date calculateBusinessTimeAsDate(String timeExpression) {
            return null;
        }
    }

    public static class TestMarshallingStrategy
    implements ObjectMarshallingStrategy {
        private static final String ALWAYS_RESPOND_WITH = "custom marshaller invoked";

        public boolean accept(Object o) {
            return o instanceof String;
        }

        public void write(ObjectOutputStream objectOutputStream, Object o) throws IOException {
        }

        public Object read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            return ALWAYS_RESPOND_WITH;
        }

        public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream objectOutputStream, Object o) throws IOException {
            return ((String)o).getBytes();
        }

        public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream objectInputStream, byte[] bytes, ClassLoader classLoader) throws IOException, ClassNotFoundException {
            return ALWAYS_RESPOND_WITH;
        }

        public ObjectMarshallingStrategy.Context createContext() {
            return null;
        }
    }

    public static class TestProcessEventListener
    extends DefaultProcessEventListener {
        public void beforeProcessStarted(ProcessStartedEvent processStartedEvent) {
            processEvents.add("beforeProcessStarted");
        }

        public void afterProcessStarted(ProcessStartedEvent processStartedEvent) {
            processEvents.add("afterProcessStarted");
        }

        public void beforeProcessCompleted(ProcessCompletedEvent processCompletedEvent) {
            processEvents.add("beforeProcessCompleted");
        }

        public void afterProcessCompleted(ProcessCompletedEvent processCompletedEvent) {
            processEvents.add("afterProcessCompleted");
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent processVariableChangedEvent) {
            processEvents.add("beforeVariableChanged");
        }

        public void afterVariableChanged(ProcessVariableChangedEvent processVariableChangedEvent) {
            processEvents.add("afterVariableChanged");
        }
    }

    public static class TestTaskEventListener
    extends DefaultTaskEventListener {
        public void beforeTaskStartedEvent(TaskEvent taskEvent) {
            taskEvents.add("beforeTaskStartedEvent");
        }

        public void beforeTaskCompletedEvent(TaskEvent taskEvent) {
            taskEvents.add("beforeTaskCompletedEvent");
        }

        public void beforeTaskAddedEvent(TaskEvent taskEvent) {
            taskEvents.add("beforeTaskAddedEvent");
        }

        public void beforeTaskSuspendedEvent(TaskEvent taskEvent) {
            taskEvents.add("beforeTaskSuspendedEvent");
        }

        public void afterTaskStartedEvent(TaskEvent taskEvent) {
            taskEvents.add("afterTaskStartedEvent");
        }

        public void afterTaskCompletedEvent(TaskEvent taskEvent) {
            taskEvents.add("afterTaskCompletedEvent");
        }

        public void afterTaskAddedEvent(TaskEvent taskEvent) {
            taskEvents.add("afterTaskAddedEvent");
        }
    }

    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private static List<WorkItem> workItems = new ArrayList<WorkItem>();

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public static WorkItem getWorkItem() {
            if (workItems.size() == 0) {
                return null;
            }
            if (workItems.size() == 1) {
                WorkItem result = workItems.get(0);
                workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public static List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(workItems);
            workItems.clear();
            return result;
        }
    }
}

