/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;

public class DeploymentDescriptorMergerTest {
    private static final String jarLocRegexStr = "([\\d\\.]{3})\\S*";
    private static final Pattern jarLocRegex = Pattern.compile("([\\d\\.]{3})\\S*");

    @Test
    public void testDeploymentDesciptorMergeOverrideAll() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)master.getLimitSerializationClasses());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals((Object)"my.custom.unit", (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)slave.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.OVERRIDE_ALL);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"my.custom.unit", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeKeepAll() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)master.getLimitSerializationClasses());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals((Object)"my.custom.unit", (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)slave.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.KEEP_ALL);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeOverrideEmpty() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)master.getLimitSerializationClasses());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("");
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals(null, (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        slave.setLimitSerializationClasses(null);
        Assert.assertNull((Object)slave.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.OVERRIDE_EMPTY);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollections() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)master.getLimitSerializationClasses());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.AnotherCustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals(null, (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)slave.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)2L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeHierarchy() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.NONE).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2");
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals((Object)"my.custom.unit", (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.NONE, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        DeploymentDescriptorImpl slave2 = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave2.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit2").auditPersistenceUnit("my.custom.altered").runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).addEnvironmentEntry(new NamedObjectModel("IS_JTA", "java.lang.Boolean", new Object[]{"false"}));
        Assert.assertNotNull((Object)slave2);
        Assert.assertEquals((Object)"my.custom.unit2", (Object)slave2.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.altered", (Object)slave2.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave2.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave2.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)slave2.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave2.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave2.getConfiguration().size());
        Assert.assertEquals((long)1L, (long)slave2.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave2.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave2.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave2.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave2.getWorkItemHandlers().size());
        ArrayList<DeploymentDescriptorImpl> hierarchy = new ArrayList<DeploymentDescriptorImpl>();
        hierarchy.add(slave2);
        hierarchy.add(slave);
        hierarchy.add(master);
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge(hierarchy, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"my.custom.unit2", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.altered", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)1L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicates() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getWorkItemHandlers().size());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals(null, (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getWorkItemHandlers().size());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicatesNamedObject() {
        DeploymentDescriptorImpl master = new DeploymentDescriptorImpl("org.jbpm.domain");
        master.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0]));
        Assert.assertNotNull((Object)master);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)master.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)master.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)master.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)master.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)master.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)master.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)master.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)master.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)master.getGlobals().size());
        Assert.assertEquals((long)0L, (long)master.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)master.getWorkItemHandlers().size());
        DeploymentDescriptorImpl slave = new DeploymentDescriptorImpl("org.jbpm.domain");
        slave.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", new Object[0]));
        Assert.assertNotNull((Object)slave);
        Assert.assertEquals(null, (Object)slave.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)slave.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)slave.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)slave.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)slave.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)slave.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)slave.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)slave.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)slave.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)slave.getGlobals().size());
        Assert.assertEquals((long)0L, (long)slave.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)slave.getWorkItemHandlers().size());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)master, (DeploymentDescriptor)slave, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)outcome.getWorkItemHandlers().size());
        NamedObjectModel model = (NamedObjectModel)outcome.getWorkItemHandlers().get(0);
        Assert.assertEquals((Object)"Log", (Object)model.getName());
        Assert.assertEquals((Object)"new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", (Object)model.getIdentifier());
    }

    @Test
    public void changeDefaultLimitSerializationClassesValueToTrueIn7x() throws Exception {
        Properties props = new Properties();
        String testPropsFileName = "test.properties";
        InputStream testPropsStream = this.getClass().getResourceAsStream("/" + testPropsFileName);
        Assert.assertNotNull((String)("Unable to find or open " + testPropsFileName), (Object)testPropsFileName);
        props.load(testPropsStream);
        String projectVersionStr = (String)props.get("project.version");
        Matcher matcher = jarLocRegex.matcher(projectVersionStr);
        Assert.assertTrue((String)"Fix regular expression: ([\\d\\.]{3})\\S*", (boolean)matcher.matches());
        DeploymentDescriptorImpl depDesc = new DeploymentDescriptorImpl();
        Assert.assertTrue((String)"The default value of 'limitSerializationClasses is TRUE", (boolean)depDesc.getLimitSerializationClasses());
    }
}

