/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.process.audit.jms.AsyncAuditLogProducer;
import org.jbpm.runtime.manager.impl.deploy.AbstractDeploymentDescriptorTest;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class DefaultRegisterableItemsFactoryTest
extends AbstractDeploymentDescriptorTest {
    private PoolingDataSourceWrapper pds;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testJmsAuditCacheInstance() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test.jms", "kjar-jms-audit", "1.0.0");
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.persistence.jpa");
        customDescriptor.getBuilder().auditMode(AuditMode.JMS);
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder(releaseId).classLoader(this.getClass().getClassLoader()).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        Assert.assertNotNull((Object)engine);
        AsyncAuditLogProducer asyncAuditLogProducer = null;
        KieSession kieSession = engine.getKieSession();
        for (ProcessEventListener listener : kieSession.getProcessEventListeners()) {
            if (!(listener instanceof AsyncAuditLogProducer)) continue;
            asyncAuditLogProducer = (AsyncAuditLogProducer)listener;
            break;
        }
        Assert.assertNotNull(asyncAuditLogProducer);
        this.manager.close();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine engine2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession kieSession2 = engine2.getKieSession();
        AsyncAuditLogProducer asyncAuditLogProducer2 = null;
        for (ProcessEventListener listener : kieSession2.getProcessEventListeners()) {
            if (!(listener instanceof AsyncAuditLogProducer)) continue;
            asyncAuditLogProducer2 = (AsyncAuditLogProducer)listener;
            break;
        }
        Assert.assertNotNull(asyncAuditLogProducer2);
        Assert.assertEquals((Object)asyncAuditLogProducer, asyncAuditLogProducer2);
    }
}

