/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.runtime.manager.impl.CustomUserInfoImpl;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.PropertyUserInfoImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.task.UserInfo;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class RuntimeTimeTaskConfiguratorTest
extends AbstractBaseTest {
    private static String oldUserInfoValue;
    private static String oldUserInfoImpl;
    private PoolingDataSourceWrapper pds;

    @BeforeClass
    public static void enter() {
        oldUserInfoValue = System.setProperty("org.jbpm.ht.userinfo", "custom");
        oldUserInfoImpl = System.setProperty("org.jbpm.ht.custom.userinfo", "org.jbpm.runtime.manager.impl.CustomUserInfoImpl");
    }

    @AfterClass
    public static void exit() {
        if (oldUserInfoValue != null) {
            System.setProperty("org.jbpm.ht.userinfo", oldUserInfoValue);
        } else {
            System.clearProperty("org.jbpm.ht.userinfo");
        }
        if (oldUserInfoImpl != null) {
            System.setProperty("org.jbpm.ht.custom.userinfo", oldUserInfoImpl);
        } else {
            System.clearProperty("org.jbpm.ht.custom.userinfo");
        }
    }

    @Before
    public void setup() {
        this.pds = TestUtil.setupPoolingDataSource();
    }

    @After
    public void teardown() {
        this.pds.close();
    }

    @Test
    public void testRuntimeEnvironmentUserInfo() {
        PropertyUserInfoImpl userInfo = new PropertyUserInfoImpl(true);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).userInfo((UserInfo)userInfo).get();
        LocalTaskServiceFactory factory = new LocalTaskServiceFactory(environment);
        InternalTaskService service = (InternalTaskService)factory.newTaskService();
        Assert.assertTrue((boolean)service.getUserInfo().equals(userInfo));
    }

    @Test
    public void testRuntimeEnvironmentUserDataServiceProviderUserInfo() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).get();
        LocalTaskServiceFactory factory = new LocalTaskServiceFactory(environment);
        InternalTaskService service = (InternalTaskService)factory.newTaskService();
        Assert.assertTrue((boolean)(service.getUserInfo() instanceof CustomUserInfoImpl));
    }
}

