/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.util.Random;
import org.assertj.core.api.Assertions;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.junit.After;
import org.junit.Test;

public class ExecutionErrorInfoTest {
    @After
    public void tearUp() {
        System.clearProperty("org.kie.jbpm.error.log.length");
    }

    @Test
    public void testTrimmedErrorMessage() {
        ExecutionErrorInfo info = new ExecutionErrorInfo();
        String randomString = this.randomString(300);
        info.setErrorMessage(randomString);
        Assertions.assertThat((int)info.getErrorMessage().length()).isEqualTo(255);
        Assertions.assertThat((String)info.getErrorMessage()).isEqualTo(randomString.substring(0, 255));
    }

    @Test
    public void testTrimmedNotDefaultErrorMessage() {
        System.setProperty("org.kie.jbpm.error.log.length", "5");
        String randomString = this.randomString(100);
        ExecutionErrorInfo info = new ExecutionErrorInfo();
        info.setErrorMessage(randomString);
        Assertions.assertThat((int)info.getErrorMessage().length()).isEqualTo(5);
        Assertions.assertThat((String)info.getErrorMessage()).isEqualTo(randomString.substring(0, 5));
    }

    @Test
    public void testDefaultErrorMessage() {
        String randomString = this.randomString(100);
        ExecutionErrorInfo info = new ExecutionErrorInfo();
        info.setErrorMessage(randomString);
        Assertions.assertThat((int)info.getErrorMessage().length()).isEqualTo(100);
        Assertions.assertThat((String)info.getErrorMessage()).isEqualTo(randomString);
    }

    private String randomString(int size) {
        char[] array = new char[size];
        Random random = new Random();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (char)random.nextInt();
        }
        return String.valueOf(array);
    }
}

