/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbpm.runtime.manager.impl.lock.CriticalSectionClash;
import org.jbpm.runtime.manager.impl.lock.DebugRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.impl.lock.Runner;
import org.jbpm.runtime.manager.impl.lock.RuntimeManagerLockStrategyFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRuntimeManagerLockStrategyTest {
    protected static final Logger logger = LoggerFactory.getLogger(CustomRuntimeManagerLockStrategyTest.class);
    private static final int NUMBER_OF_WORKING_THREADS = 10;
    private ExecutorService executorService;

    @Before
    public void init() {
        this.executorService = Executors.newFixedThreadPool(10);
    }

    @After
    public void destroy() {
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Test(timeout=10000L)
    public void testTimeout() throws Exception {
        CriticalSectionClash sectionDetection = new CriticalSectionClash();
        String factory = DebugRuntimeManagerLockFactory.class.getName();
        RuntimeManagerLockStrategy lockStrategy = new RuntimeManagerLockStrategyFactory("org.jbpm.runtime.manager.impl.lock.TimeoutRuntimeManagerLockStrategy", factory).createLockStrategy("timeout");
        AtomicInteger count = new AtomicInteger(0);
        this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, true)).get();
        this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, false));
        logger.info("finished jobs test TimeoutRuntimeManagerLockStrategy");
        this.executorService.shutdown();
        this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.executorService.isTerminated());
        logger.info("exiting test TimeoutRuntimeManagerLockStrategy");
    }

    @Test(timeout=10000L)
    public void testInterruptible() throws Exception {
        CriticalSectionClash sectionDetection = new CriticalSectionClash();
        String factory = DebugRuntimeManagerLockFactory.class.getName();
        RuntimeManagerLockStrategy lockStrategy = new RuntimeManagerLockStrategyFactory("org.jbpm.runtime.manager.impl.lock.InterruptibleRuntimeManagerLockStrategy", factory).createLockStrategy("interruptible");
        AtomicInteger count = new AtomicInteger(0);
        this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, true)).get();
        Future<Boolean> job = this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, false));
        Thread.sleep(1000L);
        job.cancel(true);
        logger.info("finished jobs test TimeoutRuntimeManagerLockStrategy");
        this.executorService.shutdown();
        this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.executorService.isTerminated());
        logger.info("exiting test TimeoutRuntimeManagerLockStrategy");
    }
}

