/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.runtime.manager.impl.deploy.AbstractDeploymentDescriptorTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorIO;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.test.util.compare.ComparePair;

public class DeploymentDescriptorManagerTest
extends AbstractDeploymentDescriptorTest {
    private static final String SIMPLE_DRL = "package org.jbpm; \trule \"Start Hello1\"\t  when\t  then\t    System.out.println(\"Hello\");\tend";
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0-SNAPSHOT";
    private static Random random = new Random();

    @Test
    public void testDefaultDeploymentDescriptor() {
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        DeploymentDescriptor descriptor = manager.getDefaultDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDefaultDeploymentDescriptorFromClasspath() {
        System.setProperty("org.kie.deployment.desc.location", "classpath:/deployment/deployment-descriptor-defaults-and-ms.xml");
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        DeploymentDescriptor descriptor = manager.getDefaultDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDefaultDeploymentDescriptorFromFile() {
        System.setProperty("org.kie.deployment.desc.location", "file:src/test/resources/deployment/deployment-descriptor-defaults-and-ms.xml");
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        DeploymentDescriptor descriptor = manager.getDefaultDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDescriptorFromKieContainerNoDescInKjar() {
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/simple.drl", SIMPLE_DRL);
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        List descriptorHierarchy = manager.getDeploymentDescriptorHierarchy(kieContainer);
        Assert.assertNotNull((Object)descriptorHierarchy);
        Assert.assertEquals((long)1L, (long)descriptorHierarchy.size());
        DeploymentDescriptor descriptor = (DeploymentDescriptor)descriptorHierarchy.get(0);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDescriptorFromKieContainer() {
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/simple.drl", SIMPLE_DRL);
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", descriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, new ReleaseId[0]);
        this.installKjar(releaseId, kJar1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        List descriptorHierarchy = manager.getDeploymentDescriptorHierarchy(kieContainer);
        Assert.assertNotNull((Object)descriptorHierarchy);
        Assert.assertEquals((long)2L, (long)descriptorHierarchy.size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(0);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(1);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDescriptorFromKieContainerWithDependency() {
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseIdDep = ks.newReleaseId(GROUP_ID, "dependency-data", VERSION);
        DeploymentDescriptorImpl descriptorDep = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptorDep.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).auditPersistenceUnit("org.jbpm.audit");
        HashMap<String, String> resourcesDep = new HashMap<String, String>();
        resourcesDep.put("src/main/resources/simple.drl", SIMPLE_DRL);
        resourcesDep.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", descriptorDep.toXml());
        InternalKieModule kJarDep = this.createKieJar(ks, releaseIdDep, resourcesDep, new ReleaseId[0]);
        this.installKjar(releaseIdDep, kJarDep);
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/simple.drl", SIMPLE_DRL);
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", descriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, releaseIdDep);
        this.installKjar(releaseId, kJar1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        List descriptorHierarchy = manager.getDeploymentDescriptorHierarchy(kieContainer);
        Assert.assertNotNull((Object)descriptorHierarchy);
        Assert.assertEquals((long)3L, (long)descriptorHierarchy.size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(0);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(1);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.audit", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(2);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDescriptorFromKieContainerWithDependencyMerged() {
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseIdDep = ks.newReleaseId(GROUP_ID, "dependency-data", VERSION);
        DeploymentDescriptorImpl descriptorDep = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptorDep.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).auditPersistenceUnit("org.jbpm.audit").addGlobal(new NamedObjectModel("service", "org.jbpm.global.Service", new Object[0]));
        HashMap<String, String> resourcesDep = new HashMap<String, String>();
        resourcesDep.put("src/main/resources/simple.drl", SIMPLE_DRL);
        resourcesDep.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", descriptorDep.toXml());
        InternalKieModule kJarDep = this.createKieJar(ks, releaseIdDep, resourcesDep, new ReleaseId[0]);
        this.installKjar(releaseIdDep, kJarDep);
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
        HashMap<String, String> resources = new HashMap<String, String>();
        resources.put("src/main/resources/simple.drl", SIMPLE_DRL);
        resources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", descriptor.toXml());
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, resources, releaseIdDep);
        this.installKjar(releaseId, kJar1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        List descriptorHierarchy = manager.getDeploymentDescriptorHierarchy(kieContainer);
        Assert.assertNotNull((Object)descriptorHierarchy);
        Assert.assertEquals((long)3L, (long)descriptorHierarchy.size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(0);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(1);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.audit", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)1L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        descriptor = (DeploymentDescriptor)descriptorHierarchy.get(2);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge(descriptorHierarchy, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)1L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
    }

    @Test
    public void roundTripDescriptorMarshallingTest() throws Exception {
        DeploymentDescriptorImpl depDescImpl = new DeploymentDescriptorImpl();
        LinkedList<Field> fieldsToFill = new LinkedList<Field>();
        for (Field field : DeploymentDescriptorImpl.class.getDeclaredFields()) {
            if (field.getAnnotation(XmlElement.class) == null) continue;
            fieldsToFill.add(field);
        }
        for (Field field : fieldsToFill) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType.equals(String.class)) {
                field.set(depDescImpl, DeploymentDescriptorManagerTest.getStringVal());
                continue;
            }
            if (fieldType.equals(Boolean.class)) {
                field.set(depDescImpl, true);
                continue;
            }
            if (fieldType.equals(PersistenceMode.class)) {
                field.set(depDescImpl, PersistenceMode.NONE);
                continue;
            }
            if (fieldType.equals(AuditMode.class)) {
                field.set(depDescImpl, AuditMode.JMS);
                continue;
            }
            if (fieldType.equals(RuntimeStrategy.class)) {
                field.set(depDescImpl, RuntimeStrategy.PER_PROCESS_INSTANCE);
                continue;
            }
            if (!Set.class.isAssignableFrom(fieldType)) continue;
            Type genType = field.getGenericType();
            Type genParamType = ((ParameterizedType)genType).getActualTypeArguments()[0];
            HashSet<String> val = new HashSet<String>();
            if (genParamType.equals(String.class)) {
                val.add(DeploymentDescriptorManagerTest.getStringVal());
            } else if (genParamType.equals(ObjectModel.class)) {
                val.add((String)DeploymentDescriptorManagerTest.getObjectModelParameter(DeploymentDescriptorManagerTest.getStringVal(), false));
            } else if (genParamType.equals(NamedObjectModel.class)) {
                val.add((String)DeploymentDescriptorManagerTest.getObjectModelParameter(DeploymentDescriptorManagerTest.getStringVal(), true));
            }
            field.set(depDescImpl, val);
        }
        String depDescXml = DeploymentDescriptorIO.toXml((DeploymentDescriptor)depDescImpl);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(depDescXml.getBytes());
        DeploymentDescriptor copyDepDescImpl = DeploymentDescriptorIO.fromXml((InputStream)inputStream);
        new ComparePair((Object)depDescImpl, (Object)copyDepDescImpl).addNullFields(new String[]{"mappedRoles"}).useFields().compare();
    }

    private static String getStringVal() {
        String val = UUID.randomUUID().toString();
        return val.substring(0, val.indexOf("-"));
    }

    private static ObjectModel getObjectModelParameter(String resolver, boolean named) {
        if (named) {
            return new NamedObjectModel(resolver, UUID.randomUUID().toString(), Integer.toString(random.nextInt(100000)), new Object[0]);
        }
        return new ObjectModel(resolver, UUID.randomUUID().toString(), new Object[]{Integer.toString(random.nextInt(100000))});
    }
}

