/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.admin.listener.TaskCleanUpProcessEventListener;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

public class AdHocSubprocessAbortRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private EntityManagerFactory emf;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testSingletonRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testAdHocSubprocess();
    }

    @Test
    public void testPerProcessInstanceRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testAdHocSubprocess();
    }

    @Test
    public void testPerRequestRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testAdHocSubprocess();
    }

    @Test
    public void testPerCaseRuntimeManagerScopeSignal() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testAdHocSubprocess();
    }

    private void testAdHocSubprocess() {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance processInstance = ksession1.startProcess("jbpm-abort-ht-issue.ad-hoc-abort-ht");
        this.manager.disposeRuntimeEngine(runtime1);
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession1 = runtime1.getKieSession();
        ksession1.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(runtime1.getTaskService()));
        ksession1.signalEvent("Milestone", null, processInstance.getId());
        this.manager.disposeRuntimeEngine(runtime1);
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog pi1Log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)pi1Log);
        Assert.assertEquals((long)2L, (long)pi1Log.getStatus().intValue());
        auditService.dispose();
        this.manager.close();
    }

    private RuntimeEnvironment createEnvironment() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"adhoc-subprocess.bpmn2"), ResourceType.BPMN2).get();
        return environment;
    }
}

