/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;

public class MultiInstanceCallActivityRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private EntityManagerFactory emf;
    private RuntimeManager manager;
    private NodeLeftCountDownProcessEventListener countDownListener;
    private int numberOfChildProcesses = 15;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testSingletonMultiInstanceCallactivityCompleteAtTheSameTime() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testMultiInstanceCallactivityCompleteAtTheSameTime((Context<?>)ProcessInstanceIdContext.get());
    }

    @Test(timeout=10000L)
    public void testPerProcessInstanceMultiInstanceCallactivityCompleteAtTheSameTime() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testMultiInstanceCallactivityCompleteAtTheSameTime((Context<?>)ProcessInstanceIdContext.get());
    }

    @Test(timeout=10000L)
    public void testPerCaseMultiInstanceCallactivityCompleteAtTheSameTime() {
        RuntimeEnvironment environment = this.createEnvironment();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment, "first");
        Assert.assertNotNull((Object)this.manager);
        this.testMultiInstanceCallactivityCompleteAtTheSameTime((Context<?>)CaseContext.get((String)"CASE-00000001"));
    }

    public void testMultiInstanceCallactivityCompleteAtTheSameTime(Context<?> startContext) {
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine(startContext);
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < this.numberOfChildProcesses; ++i) {
            items.add(i + "");
        }
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("items", items);
        ProcessInstance processInstance = ksession1.startProcess("test.Parent", params);
        this.manager.disposeRuntimeEngine(runtime1);
        this.countDownListener.waitTillCompleted();
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog pi1Log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)pi1Log);
        Assert.assertEquals((long)2L, (long)pi1Log.getStatus().intValue());
        auditService.dispose();
        this.manager.close();
    }

    private RuntimeEnvironment createEnvironment() {
        this.countDownListener = new NodeLeftCountDownProcessEventListener("timer", this.numberOfChildProcesses);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/Parent.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/Child.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(MultiInstanceCallActivityRuntimeManagerTest.this.countDownListener);
                return listeners;
            }
        }).get();
        return environment;
    }
}

