/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class PerCaseRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSource pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private EntityManagerFactory emf;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
    }

    @After
    public void teardown() {
        this.manager.close();
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testCreationOfSession() {
        final HashSet ksessionUsed = new HashSet();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id > 0L ? 1 : 0) != 0);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-2"));
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id > ksession1Id ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.disposeRuntimeEngine(runtime2);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.disposeRuntimeEngine(runtime2);
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-2"));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        Assert.assertEquals((long)2L, (long)ksessionUsed.size());
        Assert.assertTrue((boolean)ksessionUsed.contains(ksession1Id));
        Assert.assertTrue((boolean)ksessionUsed.contains(ksession2Id));
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.disposeRuntimeEngine(runtime2);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcessesWithPeristence() {
        final HashSet ksessionUsed = new HashSet();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession = runtime.getKieSession();
        long ksession1Id = ksession.getIdentifier();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        AuditService auditService = runtime.getAuditService();
        List throwProcessLogs = auditService.findProcessInstances("com.sample.bpmn.hello");
        List catchProcessLogs = auditService.findProcessInstances("com.sample.bpmn.Second");
        Assert.assertNotNull((Object)throwProcessLogs);
        Assert.assertEquals((long)1L, (long)throwProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)throwProcessLogs.get(0)).getStatus().intValue());
        Assert.assertNotNull((Object)catchProcessLogs);
        Assert.assertEquals((long)1L, (long)catchProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)catchProcessLogs.get(0)).getStatus().intValue());
        Assert.assertEquals((long)1L, (long)ksessionUsed.size());
        Assert.assertEquals((long)ksession1Id, (long)((Long)ksessionUsed.iterator().next()));
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testExecuteReusableSubprocess() {
        final HashSet ksessionUsed = new HashSet();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession = runtime.getKieSession();
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        String externalId = ((ProcessInstanceLog)logs.get(0)).getExternalId();
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)externalId);
        logs = logService.findProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        externalId = ((ProcessInstanceLog)logs.get(0)).getExternalId();
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)externalId);
        Assert.assertEquals((long)1L, (long)ksessionUsed.size());
        Assert.assertEquals((long)ksession1Id, (long)((Long)ksessionUsed.iterator().next()));
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testMultipleProcessesInSingleCaseCompletedInSequence() {
        final HashSet ksessionUsed = new HashSet();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id > 0L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)2L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession = runtime.getKieSession();
        ProcessInstance pi2 = ksession.startProcess("ScriptTask");
        Assert.assertEquals((long)2L, (long)pi2.getState());
        Assert.assertEquals((long)1L, (long)ksessionUsed.size());
        Assert.assertEquals((long)ksession1Id, (long)((Long)ksessionUsed.iterator().next()));
        this.manager.close();
    }

    @Test(timeout=10000L)
    public void testTimerOnPerCaseManager() throws Exception {
        final HashSet ksessionUsed = new HashSet();
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        final ArrayList timerExpirations = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void afterNodeLeft(ProcessNodeLeftEvent event) {
                        if (event.getNodeInstance().getNodeName().equals("timer")) {
                            timerExpirations.add(event.getProcessInstance().getId());
                            ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                        }
                    }
                });
                listeners.add(new DefaultProcessEventListener(){

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        ksessionUsed.add(((KieSession)event.getKieRuntime()).getIdentifier());
                    }
                });
                listeners.add(countDownListener);
                return listeners;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession = runtime.getKieSession();
        long ksession1Id = ksession.getIdentifier();
        ProcessInstance pi1 = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        runtime = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession = runtime.getKieSession();
        ksession.abortProcessInstance(pi1.getId());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        Assert.assertEquals((long)1L, (long)ksessionUsed.size());
        Assert.assertEquals((long)ksession1Id, (long)((Long)ksessionUsed.iterator().next()));
    }

    @Test
    public void testSignalEventWithDeactivate() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        KieSession ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }

    @Test(timeout=10000L)
    public void testTimerStartWithDeactivate() {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerStart.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        countDownListener.waitTillCompleted();
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(2000L);
        runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        runtime1 = this.manager.getRuntimeEngine((Context)CaseContext.get((String)"Case-1"));
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }
}

