/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;

public class DeploymentDescriptorMergerTest {
    private static final String jarLocRegexStr = "([\\d\\.]{3})\\S*";
    private static final Pattern jarLocRegex = Pattern.compile("([\\d\\.]{3})\\S*");

    @Test
    public void testDeploymentDesciptorMergeOverrideAll() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)primary.getLimitSerializationClasses());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals((Object)"my.custom.unit", (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)secondary.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.OVERRIDE_ALL);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"my.custom.unit", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeKeepAll() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)primary.getLimitSerializationClasses());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals((Object)"my.custom.unit", (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)secondary.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.KEEP_ALL);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeOverrideEmpty() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)primary.getLimitSerializationClasses());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("");
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals(null, (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        secondary.setLimitSerializationClasses(null);
        Assert.assertNull((Object)secondary.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.OVERRIDE_EMPTY);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollections() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        Assert.assertTrue((boolean)primary.getLimitSerializationClasses());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.AnotherCustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(false));
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals(null, (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)secondary.getLimitSerializationClasses());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)2L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
        Assert.assertFalse((boolean)outcome.getLimitSerializationClasses());
    }

    @Test
    public void testDeploymentDesciptorMergeHierarchy() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.NONE).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2");
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals((Object)"my.custom.unit", (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.unit2", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.NONE, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        DeploymentDescriptorImpl secondary2 = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary2.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit2").auditPersistenceUnit("my.custom.altered").runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).addEnvironmentEntry(new NamedObjectModel("IS_JTA", "java.lang.Boolean", new Object[]{"false"}));
        Assert.assertNotNull((Object)secondary2);
        Assert.assertEquals((Object)"my.custom.unit2", (Object)secondary2.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.altered", (Object)secondary2.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary2.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary2.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)secondary2.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary2.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary2.getConfiguration().size());
        Assert.assertEquals((long)1L, (long)secondary2.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary2.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary2.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary2.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary2.getWorkItemHandlers().size());
        ArrayList<DeploymentDescriptorImpl> hierarchy = new ArrayList<DeploymentDescriptorImpl>();
        hierarchy.add(secondary2);
        hierarchy.add(secondary);
        hierarchy.add(primary);
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge(hierarchy, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"my.custom.unit2", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"my.custom.altered", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)1L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicates() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getWorkItemHandlers().size());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals(null, (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getWorkItemHandlers().size());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getWorkItemHandlers().size());
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicatesNamedObject() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0]));
        Assert.assertNotNull((Object)primary);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)primary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)primary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)primary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)primary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)primary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)primary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)primary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)primary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)primary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)primary.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)primary.getWorkItemHandlers().size());
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", new Object[0]));
        Assert.assertNotNull((Object)secondary);
        Assert.assertEquals(null, (Object)secondary.getPersistenceUnit());
        Assert.assertEquals((Object)"", (Object)secondary.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)secondary.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)secondary.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)secondary.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)secondary.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)secondary.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)secondary.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)secondary.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)secondary.getGlobals().size());
        Assert.assertEquals((long)0L, (long)secondary.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)secondary.getWorkItemHandlers().size());
        DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
        DeploymentDescriptor outcome = merger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, MergeMode.MERGE_COLLECTIONS);
        Assert.assertNotNull((Object)outcome);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)outcome.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)outcome.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)outcome.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)outcome.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)outcome.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)outcome.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)outcome.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)outcome.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)outcome.getGlobals().size());
        Assert.assertEquals((long)0L, (long)outcome.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)outcome.getWorkItemHandlers().size());
        NamedObjectModel model = (NamedObjectModel)outcome.getWorkItemHandlers().get(0);
        Assert.assertEquals((Object)"Log", (Object)model.getName());
        Assert.assertEquals((Object)"new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", (Object)model.getIdentifier());
    }

    @Test
    public void changeDefaultLimitSerializationClassesValueToTrueIn7x() throws Exception {
        Properties props = new Properties();
        String testPropsFileName = "test.properties";
        InputStream testPropsStream = this.getClass().getResourceAsStream("/" + testPropsFileName);
        Assert.assertNotNull((String)("Unable to find or open " + testPropsFileName), (Object)testPropsFileName);
        props.load(testPropsStream);
        String projectVersionStr = (String)props.get("project.version");
        Matcher matcher = jarLocRegex.matcher(projectVersionStr);
        Assert.assertTrue((String)"Fix regular expression: ([\\d\\.]{3})\\S*", (boolean)matcher.matches());
        DeploymentDescriptorImpl depDesc = new DeploymentDescriptorImpl();
        Assert.assertTrue((String)"The default value of 'limitSerializationClasses is TRUE", (boolean)depDesc.getLimitSerializationClasses());
    }
}

