/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbpm.runtime.manager.impl.lock.CriticalSectionClash;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner
implements Callable<Boolean> {
    protected static final Logger logger = LoggerFactory.getLogger(Runner.class);
    private AtomicInteger count;
    private CriticalSectionClash sectionDetection;
    private RuntimeManagerLockStrategy lockStrategy;
    private boolean bad;

    public Runner(AtomicInteger count, CriticalSectionClash csc, RuntimeManagerLockStrategy lockStrategy, boolean bad) {
        this.count = count;
        this.sectionDetection = csc;
        this.lockStrategy = lockStrategy;
        this.bad = bad;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            int id = this.count.incrementAndGet();
            this.lockStrategy.lock(Long.valueOf(1L), (RuntimeEngine)null);
            this.sectionDetection.set(id);
            logger.info("Critical section thread id {} thread id {}", (Object)id, (Object)Thread.currentThread().getId());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sectionDetection.unset();
            if (!this.bad) {
                this.lockStrategy.unlock(Long.valueOf(1L), (RuntimeEngine)null);
            }
        }
        catch (InterruptedException e1) {
            logger.info("interrupted !");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

