/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.PerProcessInstanceRuntimeManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.internal.KieInternalServices;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class PerProcessInstanceRuntimeManagerTest
extends AbstractBaseTest {
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    private EntityManagerFactory emf;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
    }

    @After
    public void teardown() {
        this.manager.close();
        EntityManagerFactoryManager.get().clear();
        this.pds.close();
    }

    @Test
    public void testCreationOfSession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        ksession.startProcess("ScriptTask");
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionWithPersistence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 3L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        this.manager.disposeRuntimeEngine(runtime);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        ksession2.getWorkItemManager().completeWorkItem(2L, null);
        this.manager.disposeRuntimeEngine(runtime2);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi2.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionWithPersistenceByCorrelationKey() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        CorrelationKeyFactory keyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        CorrelationKey key = keyFactory.newCorrelationKey("first");
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        CorrelationKey key2 = keyFactory.newCorrelationKey("second");
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 3L ? 1 : 0) != 0);
        ProcessInstance pi1 = ((CorrelationAwareProcessRuntime)ksession).startProcess("UserTask", key, null);
        ProcessInstance pi2 = ((CorrelationAwareProcessRuntime)ksession2).startProcess("UserTask", key2, null);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        try {
            this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key)).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        runtime2 = this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key2));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        ksession2.getWorkItemManager().completeWorkItem(2L, null);
        try {
            this.manager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key2)).getKieSession();
            Assert.fail((String)("Session for this (" + pi2.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.close();
    }

    @Test
    public void testExecuteCompleteWorkItemOnInvalidSessionWithPersistence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 3L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        this.manager.disposeRuntimeEngine(runtime);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            ksession.getWorkItemManager().completeWorkItem(2L, null);
            Assert.fail((String)("Invalid session was used for (" + pi2.getId() + ") process instance"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.close();
    }

    @Test
    public void testExecuteReusableSubprocess() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        try {
            ksession.getWorkItemManager().completeWorkItem(1L, null);
            Assert.fail((String)("Invalid session was used for subprocess of (" + pi1.getId() + ") process instance"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)2L));
        ksession = runtime.getKieSession();
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        String externalId = ((ProcessInstanceLog)logs.get(0)).getExternalId();
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)externalId);
        logs = logService.findProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        externalId = ((ProcessInstanceLog)logs.get(0)).getExternalId();
        Assert.assertEquals((Object)this.manager.getIdentifier(), (Object)externalId);
        this.manager.close();
    }

    @Test
    public void testStartTwoProcessIntancesOnSameSession() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        try {
            ProcessInstance pi2 = ksession.startProcess("UserTask");
            Assert.fail((String)("Invalid session was used for (" + pi2.getId() + ") process instance"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.close();
    }

    @Test
    public void testCreationOfRuntimeManagerWithinTransaction() throws Exception {
        System.setProperty("jbpm.tm.jndi.lookup", "java:comp/UserTransaction");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("ScriptTask");
        ut.commit();
        System.clearProperty("jbpm.tm.jndi.lookup");
    }

    @Test
    public void testCreationOfSessionWithEmptyContext() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.disposeRuntimeEngine(runtime2);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionTaskServiceNotConfigured() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        try {
            runtime.getTaskService();
            Assert.fail((String)"Should fail as task service is not configured");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"TaskService was not configured", (Object)e.getMessage());
        }
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionWithCustomTaskListener() {
        final ArrayList addedTasks = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<TaskLifeCycleEventListener> getTaskListeners() {
                List listeners = super.getTaskListeners();
                listeners.add(new DefaultTaskEventListener(){

                    public void afterTaskAddedEvent(TaskEvent event) {
                        addedTasks.add(event.getTask().getId());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        ksession.startProcess("ScriptTask");
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        Assert.assertEquals((long)2L, (long)addedTasks.size());
        this.manager.close();
    }

    @Test
    public void testCreationOfSessionCustomTaskServiceFactory() {
        final AtomicBoolean customTaskServiceUsed = new AtomicBoolean(false);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().userGroupCallback(this.userGroupCallback).entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("org.kie.internal.runtime.manager.TaskServiceFactory", (Object)new TaskServiceFactory(){
            private EntityManagerFactory emf;

            public EntityManagerFactory produceEntityManagerFactory() {
                if (this.emf == null) {
                    this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
                }
                return this.emf;
            }

            public TaskService newTaskService() {
                customTaskServiceUsed.set(true);
                return HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.produceEntityManagerFactory()).listener((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true)).getTaskService();
            }

            public void close() {
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 1L ? 1 : 0) != 0);
        ksession.startProcess("ScriptTask");
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        this.manager.close();
        Assert.assertTrue((boolean)customTaskServiceUsed.get());
    }

    @Test(timeout=30000L)
    public void testRestoreTimersAfterManagerClose() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        final ArrayList timerExpirations = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void afterNodeLeft(ProcessNodeLeftEvent event) {
                        if (event.getNodeInstance().getNodeName().equals("timer")) {
                            timerExpirations.add(event.getProcessInstance().getId());
                        }
                    }
                });
                listeners.add(countDownListener);
                return listeners;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance pi1 = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        ((AbstractRuntimeManager)this.manager).close(true);
        int currentNumberOfTriggers = timerExpirations.size();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        countDownListener.reset(2);
        countDownListener.waitTillCompleted();
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        runtime.getKieSession().abortProcessInstance(pi1.getId());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        Assert.assertTrue((timerExpirations.size() > currentNumberOfTriggers ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAuditServiceNotAvailable() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        runtime.getAuditService();
    }

    @Test
    public void testCreationOfSessionWithPersistenceAndAuditService() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        AuditService auditService = runtime.getAuditService();
        Assert.assertNotNull((Object)auditService);
        List logs = auditService.findProcessInstances();
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 3L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        logs = auditService.findProcessInstances();
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        logs = auditService.findProcessInstances();
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        this.manager.disposeRuntimeEngine(runtime);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        ksession2.getWorkItemManager().completeWorkItem(2L, null);
        auditService = runtime2.getAuditService();
        logs = auditService.findProcessInstances();
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime2);
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi2.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.manager.close();
    }

    @Test
    public void testIndependentSubprocessAbort() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.abortProcessInstance(pi1.getId());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        logs = logService.findProcessInstances("ParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        logs = logService.findProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        this.manager.close();
    }

    @Test
    public void testDependentSubprocessAbort() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-DependentCallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-DependentCallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("DependentParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.abortProcessInstance(pi1.getId());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("DependentParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findActiveProcessInstances("DependentSubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("DependentParentProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        logs = logService.findProcessInstances("DependentSubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        this.manager.close();
    }

    @Test
    public void testMultipleRuntimeEngineWithinSingleTransaction() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        long ksession2Id = ksession2.getIdentifier();
        Assert.assertTrue((ksession2Id == 3L ? 1 : 0) != 0);
        ProcessInstance pi1 = ksession.startProcess("UserTask");
        ProcessInstance pi2 = ksession2.startProcess("UserTask");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        Assert.assertEquals((long)1L, (long)pi2.getState());
        ut.commit();
        RuntimeEngine cachedRE1 = ((PerProcessInstanceRuntimeManager)this.manager).findLocalRuntime((Object)pi1.getId());
        Assert.assertNull((Object)cachedRE1);
        RuntimeEngine cachedRE2 = ((PerProcessInstanceRuntimeManager)this.manager).findLocalRuntime((Object)pi2.getId());
        Assert.assertNull((Object)cachedRE2);
        ut.begin();
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        Assert.assertEquals((long)ksession1Id, (long)ksession.getIdentifier());
        ksession.getWorkItemManager().completeWorkItem(1L, null);
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        ksession2 = runtime2.getKieSession();
        Assert.assertEquals((long)ksession2Id, (long)ksession2.getIdentifier());
        ksession2.getWorkItemManager().completeWorkItem(2L, null);
        ut.commit();
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi2.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        cachedRE1 = ((PerProcessInstanceRuntimeManager)this.manager).findLocalRuntime((Object)pi1.getId());
        Assert.assertNull((Object)cachedRE1);
        cachedRE2 = ((PerProcessInstanceRuntimeManager)this.manager).findLocalRuntime((Object)pi2.getId());
        Assert.assertNull((Object)cachedRE2);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcessesWithPeristence() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        AuditService auditService = runtime.getAuditService();
        List throwProcessLogs = auditService.findProcessInstances("com.sample.bpmn.hello");
        List catchProcessLogs = auditService.findProcessInstances("com.sample.bpmn.Second");
        Assert.assertNotNull((Object)throwProcessLogs);
        Assert.assertEquals((long)1L, (long)throwProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)throwProcessLogs.get(0)).getStatus().intValue());
        Assert.assertNotNull((Object)catchProcessLogs);
        Assert.assertEquals((long)1L, (long)catchProcessLogs.size());
        Assert.assertEquals((long)2L, (long)((ProcessInstanceLog)catchProcessLogs.get(0)).getStatus().intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testEventSignalingBetweenProcesses() {
        final HashMap processStates = new HashMap();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder().persistence(false).userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/throw-an-event.bpmn"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                ArrayList<ProcessEventListener> listeners = new ArrayList<ProcessEventListener>();
                listeners.add((ProcessEventListener)new DefaultProcessEventListener(){

                    public void afterProcessCompleted(ProcessCompletedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }

                    public void beforeProcessStarted(ProcessStartedEvent event) {
                        processStates.put(event.getProcessInstance().getProcessId(), event.getProcessInstance().getState());
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("com.sample.bpmn.hello");
        Assert.assertEquals((long)2L, (long)processStates.size());
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.hello"));
        Assert.assertTrue((boolean)processStates.containsKey("com.sample.bpmn.Second"));
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.hello")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)processStates.get("com.sample.bpmn.Second")).intValue());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test(timeout=10000L)
    public void testReusableSubprocessWithWaitForCompletionFalse() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("SLATimer", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/parentprocess.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/subprocess.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("Project01360830.parentprocess");
        countDownListener.waitTillCompleted();
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testSignalEventViaRuntimeManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2IntermediateThrowEventScope.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        Assert.assertNotNull((Object)ksession1);
        ProcessInstance processInstance = ksession1.startProcess("intermediate-event-scope");
        this.manager.disposeRuntimeEngine(runtime1);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        ProcessInstance processInstance2 = ksession2.startProcess("intermediate-event-scope");
        this.manager.disposeRuntimeEngine(runtime2);
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        List tasks1 = runtime1.getTaskService().getTasksByProcessInstanceId(processInstance.getId());
        Assert.assertNotNull((Object)tasks1);
        Assert.assertEquals((long)1L, (long)tasks1.size());
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance2.getId()));
        List tasks2 = runtime1.getTaskService().getTasksByProcessInstanceId(processInstance2.getId());
        Assert.assertNotNull((Object)tasks2);
        Assert.assertEquals((long)1L, (long)tasks2.size());
        String data = "some data";
        runtime1.getKieSession();
        runtime1.getTaskService().claim(((Long)tasks1.get(0)).longValue(), "john");
        runtime1.getTaskService().start(((Long)tasks1.get(0)).longValue(), "john");
        runtime1.getTaskService().complete(((Long)tasks1.get(0)).longValue(), "john", Collections.singletonMap("_output", data));
        this.manager.disposeRuntimeEngine(runtime1);
        this.manager.disposeRuntimeEngine(runtime2);
        runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance2.getId()));
        AuditService auditService = runtime2.getAuditService();
        ProcessInstanceLog pi1Log = auditService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)pi1Log);
        Assert.assertEquals((long)2L, (long)pi1Log.getStatus().intValue());
        ProcessInstanceLog pi2Log = auditService.findProcessInstance(processInstance2.getId());
        Assert.assertNotNull((Object)pi2Log);
        Assert.assertEquals((long)1L, (long)pi2Log.getStatus().intValue());
        List nLogs = auditService.findNodeInstances(processInstance2.getId(), "_527AF0A7-D741-4062-9953-A05E51479C80");
        Assert.assertNotNull((Object)nLogs);
        Assert.assertEquals((long)2L, (long)nLogs.size());
        auditService.dispose();
        this.manager.disposeRuntimeEngine(runtime1);
        this.manager.disposeRuntimeEngine(runtime2);
        this.manager.close();
    }

    @Test
    public void testSignalStartMultipleProcesses() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SignalMultipleProcessesMain.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SignalMultipleProcessesOne.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-SignalMultipleProcessesTwo.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("processInput", "MyCoolParam");
        ksession.startProcess("main-process", inputParams);
        AuditService auditService = runtime.getAuditService();
        List processInstanceLogs = auditService.findProcessInstances();
        Assert.assertEquals((long)3L, (long)processInstanceLogs.size());
        this.manager.close();
    }

    @Test
    public void testErrorThrowOfChildProcessOnParent() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/ParentError.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"reusable-subprocess/ChildError.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.startProcess("ParentError");
        List processInstanceLogs = runtime.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)processInstanceLogs.size());
        for (ProcessInstanceLog log : processInstanceLogs) {
            if (log.getProcessId().equals("ParentError")) {
                Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
                continue;
            }
            if (!log.getProcessId().equals("ChildError")) continue;
            Assert.assertEquals((long)3L, (long)log.getStatus().intValue());
        }
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testSignalProcessAndCheckCleanup() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-IntermediateCatchEventSignalWithRef.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ksession.startProcess("IntermediateCatchEventWithRef");
        List logs = runtime.getAuditService().findActiveProcessInstances("IntermediateCatchEventWithRef");
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.signalEvent("Signal1", null);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        logs = runtime.getAuditService().findActiveProcessInstances("IntermediateCatchEventWithRef");
        Assert.assertEquals((long)0L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        Query sessionInfoQuery = this.emf.createEntityManager().createQuery("select id from SessionInfo");
        Assert.assertEquals((long)1L, (long)sessionInfoQuery.getResultList().size());
        this.emf.close();
    }

    @Test
    public void testSignalEventWithDeactivate() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/start-on-event.bpmn"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        ksession1 = runtime1.getKieSession();
        ksession1.signalEvent("SampleEvent", null);
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }

    @Test(timeout=10000L)
    public void testTimerStartWithDeactivate() {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Hello", 1);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerStart.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(countDownListener);
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        countDownListener.waitTillCompleted();
        RuntimeEngine runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        List logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).deactivate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(2000L);
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)1L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
        ((InternalRuntimeManager)this.manager).activate();
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        runtime1 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        logs = runtime1.getAuditService().findProcessInstances();
        Assert.assertEquals((long)2L, (long)logs.size());
        this.manager.disposeRuntimeEngine(runtime1);
    }

    @Test
    public void testEndMessageEventProcess() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"events/EndMessageEvent.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                HashMap<String, WorkItemHandler> handlers = new HashMap<String, WorkItemHandler>();
                handlers.putAll(super.getWorkItemHandlers(runtime));
                handlers.put("Send Task", (WorkItemHandler)new SendTaskHandler());
                return handlers;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance pi1 = ksession.startProcess("test-process");
        Assert.assertEquals((long)2L, (long)pi1.getState());
        this.manager.close();
    }

    @Test(timeout=20000L)
    public void testTimersOnMultiInstanceSubprocess() throws Exception {
        final NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("MIDelayTimer", 2);
        final ArrayList timerExpirations = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void afterNodeLeft(ProcessNodeLeftEvent event) {
                        if (event.getNodeInstance().getNodeName().equals("MIDebugScript")) {
                            timerExpirations.add(event.getProcessInstance().getId());
                        }
                    }
                });
                listeners.add(countDownListener);
                return listeners;
            }
        }).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-MultiInstanceProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance pi1 = ksession.startProcess("defaultPackage.MultiInstanceProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        countDownListener.reset(4);
        countDownListener.waitTillCompleted(3000L);
        Assert.assertEquals((long)2L, (long)timerExpirations.size());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = runtime.getKieSession();
        pi1 = ksession.getProcessInstance(pi1.getId());
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.abortProcessInstance(pi1.getId());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testExceptionWhenCompleteTaskAfterEngineDisposal() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        TaskService taskService = runtime.getTaskService();
        List taskIds = taskService.getTasksByProcessInstanceId(processInstance.getId());
        Long taskId = (Long)taskIds.get(0);
        taskService.start(taskId.longValue(), "john");
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        HashMap params = new HashMap();
        try {
            taskService.complete(taskId.longValue(), "john", params);
            Assert.fail((String)"should throw RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Status.InProgress, (Object)taskService.getTaskById(taskId.longValue()).getTaskData().getStatus());
        String auditPu = ((InternalRuntimeManager)this.manager).getDeploymentDescriptor().getAuditPersistenceUnit();
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(auditPu);
        Query auditTaskLogQuery = emf.createEntityManager().createQuery("select status from AuditTaskImpl where taskId = :taskId").setParameter("taskId", (Object)taskId);
        Assert.assertEquals((Object)Status.InProgress.name(), auditTaskLogQuery.getResultList().get(0));
        emf.close();
    }

    @Test
    public void testIndependentSubprocessAbortLocking() throws InterruptedException {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        long ksession1Id = ksession.getIdentifier();
        Assert.assertTrue((ksession1Id == 2L ? 1 : 0) != 0);
        final ProcessInstance pi1 = ksession.startProcess("ParentProcess");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        ksession.abortProcessInstance(pi1.getId());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("SubProcess");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        long childId = ((ProcessInstanceLog)logs.get(0)).getProcessInstanceId();
        this.manager.disposeRuntimeEngine(runtime);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        ksession = runtime.getKieSession();
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>> Completing task");
        TaskService taskService = runtime.getTaskService();
        List taskIds = taskService.getTasksByProcessInstanceId(childId);
        Long taskId = (Long)taskIds.get(0);
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", new HashMap());
        this.manager.disposeRuntimeEngine(runtime);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    RuntimeEngine runtime = PerProcessInstanceRuntimeManagerTest.this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
                    runtime.getKieSession();
                }
                catch (SessionNotFoundException sessionNotFoundException) {
                    // empty catch block
                }
            }
        };
        Thread executor = new Thread(run);
        executor.start();
        executor.join();
    }
}

