/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.migration;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.listener.process.SLAViolationCountDownProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.NodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.test.util.db.PoolingDataSourceWrapper;

@RunWith(value=Parameterized.class)
public class TimerMigrationManagerTest
extends AbstractBaseTest {
    private String strategy;
    private PoolingDataSourceWrapper pds;
    private EntityManagerFactory emf;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager managerV1;
    private RuntimeManager managerV2;
    private static final String USER_JOHN = "john";
    private static final String USER_MARY = "mary";
    private static final String DEPLOYMENT_ID_V1 = "managerV1";
    private static final String DEPLOYMENT_ID_V2 = "managerV2";
    private static final String TIMER_ID_V1 = "Timer-V1";
    private static final String TIMER_ID_V2 = "Timer-V2";
    private static final String BOUNDARY_TIMER_ID_V1 = "TimerBoundaryEventV1";
    private static final String BOUNDARY_TIMER_ID_V2 = "TimerBoundaryEventV2";
    private static final String EVENT_SUBPROCESS_TIMER_ID_V1 = "BPMN2-EventSubprocessTimerV1";
    private static final String EVENT_SUBPROCESS_TIMER_ID_V2 = "BPMN2-EventSubprocessTimerV2";
    private static final String CYCLE_TIMER_ID_V1 = "CycleTimer-V1";
    private static final String CYCLE_TIMER_ID_V2 = "CycleTimer-V2";
    private static final String LOOP_TIMER_ID_V1 = "ProcessClaim.CheckDisruption-v1";
    private static final String LOOP_TIMER_ID_V2 = "ProcessClaim.CheckDisruption-v2";
    private static final String USERTASK_BOUNDARY_TIMER_ID_V1 = "UserTaskBoundary-v1";
    private static final String USERTASK_BOUNDARY_TIMER_ID_V2 = "UserTaskBoundary-v2";
    private static final String USERTASK_SLA_ID_V1 = "BPMN2-UserTaskSLA-v1";
    private static final String USERTASK_SLA_ID_V2 = "BPMN2-UserTaskSLA-v2";
    private static final String PROCESS_SLA_ID_V1 = "BPMN2-ProcessSLA-v1";
    private static final String PROCESS_SLA_ID_V2 = "BPMN2-ProcessSLA-v2";
    private static final String SLA_PROCESS_ID_V1 = "processSLA-V1";
    private static final String SLA_PROCESS_ID_V2 = "processSLA-V2";
    private static final String SLA_ON_TASK_ID_V1 = "SLAOnTask-v1";
    private static final String SLA_ON_TASK_ID_V2 = "SLAOnTask-v2";
    private JPAAuditLogService auditService;
    private RuntimeEngine runtime;
    private long pid;

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"singleton"}, {"processinstance"});
    }

    public TimerMigrationManagerTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.jpa");
        Properties properties = new Properties();
        properties.setProperty(USER_MARY, "HR");
        properties.setProperty(USER_JOHN, "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.auditService = new JPAAuditLogService(this.emf);
    }

    @After
    public void teardown() {
        this.auditService.dispose();
        if (this.managerV1 != null) {
            this.managerV1.close();
        }
        if (this.managerV2 != null) {
            this.managerV2.close();
        }
        EntityManagerFactoryManager.get().clear();
        TaskDeadlinesServiceImpl.dispose();
        this.pds.close();
    }

    @Test(timeout=10000L)
    public void testMigrateTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("EventV2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-Timer-v1.bpmn2", "migration/v2/BPMN2-Timer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testMigrateBoundaryTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("GoodbyeV2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerBoundary-v1.bpmn2", "migration/v2/BPMN2-TimerBoundary-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(BOUNDARY_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, BOUNDARY_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)BOUNDARY_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testMigrateEventSubprocessTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 1 V2", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-EventSubprocessTimer-v1.bpmn2", "migration/v2/BPMN2-EventSubprocessTimer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(EVENT_SUBPROCESS_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, EVENT_SUBPROCESS_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)EVENT_SUBPROCESS_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)3L, (long)log.getStatus().intValue());
    }

    @Test
    public void testMigrateTimerProcessInstanceRollback() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Event", 1);
        this.createRuntimeManagers("migration/v1/BPMN2-Timer-v1.bpmn2", "migration/v2/BPMN2-Timer-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = null;
        try {
            Map<String, Integer> erronousMapping = Collections.singletonMap("_3", 3);
            migrationManager.migrate(erronousMapping);
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=20000L)
    public void testMigrateTimerCycleProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("print smt", 2);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerCycle-v1.bpmn2", "migration/v2/BPMN2-TimerCycle-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Map<String, String> params = Collections.singletonMap("startTime", Instant.now().toString());
        ProcessInstance pi1 = ksession.startProcess(CYCLE_TIMER_ID_V1, params);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        countdownListener.waitTillCompleted();
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, CYCLE_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        this.runtime = this.managerV2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.signalEvent("endMe", null, pi1.getId());
        this.managerV2.disposeRuntimeEngine(this.runtime);
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=20000L)
    public void testMigrateTimerCycleProcessInstanceBeforeFirstTrigger() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("print smt", 3);
        this.createRuntimeManagers("migration/v1/BPMN2-TimerCycle-v1.bpmn2", "migration/v2/BPMN2-TimerCycle-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Map<String, String> params = Collections.singletonMap("startTime", Instant.now().plusSeconds(3L).toString());
        ProcessInstance pi1 = ksession.startProcess(CYCLE_TIMER_ID_V1, params);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, CYCLE_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(3);
        countdownListener.waitTillCompleted();
        this.runtime = this.managerV2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ksession.signalEvent("endMe", null, pi1.getId());
        this.managerV2.disposeRuntimeEngine(this.runtime);
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)CYCLE_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)2L, (long)log.getStatus().intValue());
    }

    @Test(timeout=40000L)
    public void testMigrateTimerWithLoopProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("3s timer", 1);
        this.createRuntimeManagers("migration/v1/CheckDisruption-v1.bpmn2", "migration/v2/CheckDisruption-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(LOOP_TIMER_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        countdownListener.waitTillCompleted();
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, LOOP_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V2, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V1, LOOP_TIMER_ID_V1);
        migrationManager = new MigrationManager(migrationSpec);
        report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.reset(1);
        countdownListener.waitTillCompleted();
        log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)LOOP_TIMER_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        this.runtime = this.managerV1.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        ksession = this.runtime.getKieSession();
        ksession.abortProcessInstance(pi1.getId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
    }

    @Test(timeout=10000L)
    public void testMigrateUserTaskCompletedBoundaryTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 1", 1);
        this.pid = this.startProcessTillBoundaryTimer(countdownListener);
        this.completeUserTask(this.managerV1, USER_JOHN);
        this.migrateProcessUserTaskBoundary(this.managerV1);
        this.completeUserTask(this.managerV2, USER_MARY);
        this.checkProcessCompleted(countdownListener);
    }

    @Test(timeout=10000L)
    public void testMigrateUserTaskNotCompletedBoundaryTimerProcessInstance() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 1", 1);
        this.pid = this.startProcessTillBoundaryTimer(countdownListener);
        this.migrateProcessUserTaskBoundary(this.managerV1);
        this.completeUserTask(this.managerV2, USER_JOHN);
        this.completeUserTask(this.managerV2, USER_MARY);
        this.checkProcessCompleted(countdownListener);
    }

    @Test(timeout=10000L)
    public void testMigrateSLAProcessTimer() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAProcess-v1.bpmn2", "migration/v2/BPMN2-SLAProcess-v2.bpmn2", SLA_PROCESS_ID_V1, (ProcessEventListener)countdownListener);
        this.migrate(pi, SLA_PROCESS_ID_V2);
        countdownListener.waitTillCompleted();
        this.assertSLAProcessCompliance(pi, 3);
    }

    @Test(timeout=10000L)
    public void testMigrateAfterSLAProcessTimer() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAProcess-v1.bpmn2", "migration/v2/BPMN2-SLAProcess-v2.bpmn2", SLA_PROCESS_ID_V1, (ProcessEventListener)countdownListener);
        countdownListener.waitTillCompleted();
        this.migrate(pi, SLA_PROCESS_ID_V2);
        this.assertSLAProcessCompliance(pi, 3);
    }

    @Test(timeout=10000L)
    public void testMigrateAndCompleteSLAProcessTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 2", 1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAProcess-v1.bpmn2", "migration/v2/BPMN2-SLAProcess-v2.bpmn2", SLA_PROCESS_ID_V1, (ProcessEventListener)countdownListener);
        this.migrate(pi, SLA_PROCESS_ID_V2);
        this.assertSLAProcessCompliance(pi, 1);
        this.completeUserTask(this.managerV2, USER_JOHN);
        countdownListener.waitTillCompleted();
        this.assertSLAProcessCompliance(pi, 2);
    }

    @Test(timeout=10000L)
    public void testMigrateSLAOnTaskTimer() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAOnTask-v1.bpmn2", "migration/v2/BPMN2-SLAOnTask-v2.bpmn2", SLA_ON_TASK_ID_V1, (ProcessEventListener)countdownListener);
        this.migrate(pi, SLA_ON_TASK_ID_V2);
        countdownListener.waitTillCompleted();
        this.assertSLAOnTaskCompliance(pi, 0, 3);
    }

    @Test(timeout=10000L)
    public void testMigrateAfterSLAOnTaskTimer() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAOnTask-v1.bpmn2", "migration/v2/BPMN2-SLAOnTask-v2.bpmn2", SLA_ON_TASK_ID_V1, (ProcessEventListener)countdownListener);
        countdownListener.waitTillCompleted();
        this.migrate(pi, SLA_ON_TASK_ID_V2);
        this.assertSLAOnTaskCompliance(pi, 0, 3);
    }

    @Test(timeout=10000L)
    public void testMigrateAndCompleteSLAOnTaskTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countdownListener = new NodeLeftCountDownProcessEventListener("Script Task 2", 1);
        ProcessInstance pi = this.startSLAProcess("migration/v1/BPMN2-SLAOnTask-v1.bpmn2", "migration/v2/BPMN2-SLAOnTask-v2.bpmn2", SLA_ON_TASK_ID_V1, (ProcessEventListener)countdownListener);
        this.migrate(pi, SLA_ON_TASK_ID_V2);
        this.assertSLAOnTaskCompliance(pi, 0, 1);
        this.completeUserTask(this.managerV2, USER_JOHN);
        countdownListener.waitTillCompleted();
        this.assertSLAOnTaskCompliance(pi, 1, 2);
    }

    @Test(timeout=10000L)
    public void testUserTaskSLA() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        this.createRuntimeManagers("migration/v1/BPMN2-UserTaskSLA-v1.bpmn2", "migration/v2/BPMN2-UserTaskSLA-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(USERTASK_SLA_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)USERTASK_SLA_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, USERTASK_SLA_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)USERTASK_SLA_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)USERTASK_SLA_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
    }

    @Test(timeout=10000L)
    public void testProcessSLA() throws Exception {
        SLAViolationCountDownProcessEventListener countdownListener = new SLAViolationCountDownProcessEventListener(1);
        this.createRuntimeManagers("migration/v1/BPMN2-ProcessSLA-v1.bpmn2", "migration/v2/BPMN2-ProcessSLA-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        RuntimeEngine runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(PROCESS_SLA_ID_V1);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        JPAAuditLogService auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_SLA_ID_V1, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pi1.getId()), DEPLOYMENT_ID_V2, PROCESS_SLA_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_SLA_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        countdownListener.waitTillCompleted();
        log = auditService.findProcessInstance(pi1.getId());
        auditService.dispose();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)PROCESS_SLA_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
    }

    protected void createRuntimeManagers(String processV1, String processV2, final ProcessEventListener ... eventListeners) {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV1), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                for (ProcessEventListener lister : eventListeners) {
                    listeners.add(lister);
                }
                return listeners;
            }

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("MyTask", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        RuntimeEnvironment environment2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)processV2), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                for (ProcessEventListener lister : eventListeners) {
                    listeners.add(lister);
                }
                return listeners;
            }

            public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
                Map handlers = super.getWorkItemHandlers(runtime);
                handlers.put("MyTask", new DoNothingWorkItemHandler());
                return handlers;
            }
        }).get();
        this.createRuntimeManager(environment, environment2);
    }

    private void createRuntimeManager(RuntimeEnvironment environment, RuntimeEnvironment environment2) {
        if ("singleton".equals(this.strategy)) {
            this.managerV1 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, DEPLOYMENT_ID_V1);
            this.managerV2 = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment2, DEPLOYMENT_ID_V2);
        } else if ("processinstance".equals(this.strategy)) {
            this.managerV1 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, DEPLOYMENT_ID_V1);
            this.managerV2 = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment2, DEPLOYMENT_ID_V2);
        }
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
    }

    private long startProcessTillBoundaryTimer(NodeLeftCountDownProcessEventListener countdownListener) {
        this.auditService = new JPAAuditLogService(this.emf);
        this.createRuntimeManagers("migration/v1/BPMN2-UserTaskBoundary-v1.bpmn2", "migration/v2/BPMN2-UserTaskBoundary-v2.bpmn2", new ProcessEventListener[]{countdownListener});
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        long pid = this.startProcess(this.runtime, USERTASK_BOUNDARY_TIMER_ID_V1);
        this.checkProcess(pid, USERTASK_BOUNDARY_TIMER_ID_V1, DEPLOYMENT_ID_V1, 1);
        this.managerV1.disposeRuntimeEngine(this.runtime);
        countdownListener.waitTillCompleted();
        countdownListener.reset("Goodbye v2", 1);
        return pid;
    }

    private long startProcess(RuntimeEngine runtime, String processId) {
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(processId);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        return pi1.getId();
    }

    private void checkProcess(long pid, String processId, String deploymentId, int status) {
        ProcessInstanceLog log = this.auditService.findProcessInstance(pid);
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)processId, (Object)log.getProcessId());
        Assert.assertEquals((Object)deploymentId, (Object)log.getExternalId());
        Assert.assertEquals((long)status, (long)log.getStatus().intValue());
    }

    private void migrateProcessUserTaskBoundary(RuntimeManager manager) {
        this.runtime = manager.getRuntimeEngine(EmptyContext.get());
        manager.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(this.pid), DEPLOYMENT_ID_V2, USERTASK_BOUNDARY_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        migrationManager.migrate();
        this.checkProcess(this.pid, USERTASK_BOUNDARY_TIMER_ID_V2, DEPLOYMENT_ID_V2, 1);
    }

    private void completeUserTask(RuntimeManager manager, String user) {
        this.runtime = manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = this.runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskService.start(task.getId().longValue(), user);
        taskService.complete(task.getId().longValue(), user, null);
    }

    private void checkProcessCompleted(NodeLeftCountDownProcessEventListener countdownListener) {
        countdownListener.waitTillCompleted();
        this.checkProcess(this.pid, USERTASK_BOUNDARY_TIMER_ID_V2, DEPLOYMENT_ID_V2, 2);
    }

    protected ProcessInstance startSLAProcess(String processV1, String processV2, String processId, ProcessEventListener countdownListener) {
        this.createRuntimeManagers(processV1, processV2, countdownListener);
        Assert.assertNotNull((Object)this.managerV1);
        Assert.assertNotNull((Object)this.managerV2);
        this.runtime = this.managerV1.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = this.runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess(processId);
        Assert.assertNotNull((Object)pi1);
        Assert.assertEquals((long)1L, (long)pi1.getState());
        this.auditService = new JPAAuditLogService(this.emf);
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi1.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)processId, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V1, (Object)log.getExternalId());
        this.managerV1.disposeRuntimeEngine(this.runtime);
        return pi1;
    }

    protected void migrate(ProcessInstance pid, String processId) {
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(pid.getId()), DEPLOYMENT_ID_V2, processId);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = migrationManager.migrate();
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
    }

    protected void assertSLAProcessCompliance(ProcessInstance pi, int compliance) {
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)SLA_PROCESS_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Assert.assertEquals((long)compliance, (long)log.getSlaCompliance().intValue());
    }

    protected void assertSLAOnTaskCompliance(ProcessInstance pi, int type, int compliance) {
        ProcessInstanceLog log = this.auditService.findProcessInstance(pi.getId());
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)SLA_ON_TASK_ID_V2, (Object)log.getProcessId());
        Assert.assertEquals((Object)DEPLOYMENT_ID_V2, (Object)log.getExternalId());
        Collection activeNodes = ((WorkflowProcessInstance)pi).getNodeInstances();
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        int sla = this.getSLAComplianceForNodeInstance(this.auditService, pi.getId(), (NodeInstance)activeNodes.iterator().next(), type);
        Assert.assertEquals((long)compliance, (long)sla);
    }

    protected int getSLAComplianceForNodeInstance(JPAAuditLogService logService, long processInstanceId, NodeInstance nodeInstance, int logType) {
        int slaCompliance = -1;
        List logs = logService.findNodeInstances(processInstanceId);
        if (logs != null) {
            for (NodeInstanceLog log : logs) {
                if (log.getType() != logType || !log.getNodeInstanceId().equals(String.valueOf(nodeInstance.getId()))) continue;
                return log.getSlaCompliance();
            }
        }
        return slaCompliance;
    }
}

