/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.Serializable;
import java.util.Map;
import org.drools.core.util.MVELSafeHelper;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELObjectModelResolver
implements ObjectModelResolver {
    private static final Logger logger = LoggerFactory.getLogger(MVELObjectModelResolver.class);
    public static final String ID = "mvel";

    public Object getInstance(ObjectModel model, ClassLoader cl, Map<String, Object> contextParams) {
        Object instance = null;
        InternalRuntimeManager manager = null;
        if (contextParams.containsKey("runtimeManager") && (instance = (manager = (InternalRuntimeManager)contextParams.get("runtimeManager")).getCacheManager().get(model.getIdentifier())) != null) {
            return instance;
        }
        ParserConfiguration config = new ParserConfiguration();
        config.setClassLoader(cl);
        ParserContext ctx = new ParserContext(config);
        if (contextParams != null) {
            for (Map.Entry<String, Object> entry : contextParams.entrySet()) {
                ctx.addVariable(entry.getKey(), entry.getValue().getClass());
            }
        }
        Serializable compiledExpression = MVEL.compileExpression((String)model.getIdentifier(), (ParserContext)ctx);
        instance = MVELSafeHelper.getEvaluator().executeExpression((Object)compiledExpression, contextParams);
        if (manager != null && instance instanceof Cacheable) {
            manager.getCacheManager().add(model.getIdentifier(), instance);
        }
        return instance;
    }

    public boolean accept(String resolverId) {
        if (ID.equals(resolverId)) {
            return true;
        }
        logger.debug("Resolver id {} is not accepted by {}", (Object)resolverId, this.getClass());
        return false;
    }
}

