/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.lock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbpm.runtime.manager.impl.lock.CriticalSectionClash;
import org.jbpm.runtime.manager.impl.lock.DebugRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.impl.lock.Runner;
import org.jbpm.runtime.manager.impl.lock.RuntimeManagerLockStrategyFactory;
import org.jbpm.runtime.manager.impl.lock.SelfReleaseRuntimeManagerLockFactory;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RuntimeManagerLockStrategyTest {
    protected static final Logger logger = LoggerFactory.getLogger(RuntimeManagerLockStrategyTest.class);
    private static final int NUMBER_OF_WORKING_THREADS = 10;
    private String strategy;
    private ExecutorService executorService;

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org.jbpm.runtime.manager.impl.lock.SerializableRuntimeManagerLockStrategy"}, {"org.jbpm.runtime.manager.impl.lock.TimeoutRuntimeManagerLockStrategy"}, {"org.jbpm.runtime.manager.impl.lock.InterruptibleRuntimeManagerLockStrategy"}, {"org.jbpm.runtime.manager.impl.lock.LegacyRuntimeManagerLockStrategy"});
    }

    public RuntimeManagerLockStrategyTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void init() {
        this.executorService = Executors.newFixedThreadPool(10);
    }

    @After
    public void destroy() {
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Test
    public void testLockStrategies() throws InterruptedException {
        logger.info("entering test {}", (Object)this.strategy);
        CriticalSectionClash sectionDetection = new CriticalSectionClash();
        String factory = DebugRuntimeManagerLockFactory.class.getName();
        RuntimeManagerLockStrategy lockStrategy = new RuntimeManagerLockStrategyFactory(this.strategy, factory).createLockStrategy(this.strategy);
        AtomicInteger count = new AtomicInteger(0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 100; ++i) {
            futures.add(this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, false)));
        }
        futures.forEach(e -> {
            try {
                Assert.assertTrue((boolean)((Boolean)e.get()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        logger.info("finished jobs test {}", (Object)this.strategy);
        this.executorService.shutdown();
        this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.executorService.isTerminated());
        logger.info("exiting test {}", (Object)this.strategy);
    }

    @Test
    public void testSelfRuntimeLockStrategies() throws InterruptedException {
        logger.info("entering test {}", (Object)this.strategy);
        CriticalSectionClash sectionDetection = new CriticalSectionClash();
        String factory = SelfReleaseRuntimeManagerLockFactory.class.getName();
        RuntimeManagerLockStrategy lockStrategy = new RuntimeManagerLockStrategyFactory(this.strategy, factory).createLockStrategy(this.strategy);
        AtomicInteger count = new AtomicInteger(0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 100; ++i) {
            futures.add(this.executorService.submit(new Runner(count, sectionDetection, lockStrategy, false)));
        }
        futures.forEach(e -> {
            try {
                Assert.assertTrue((boolean)((Boolean)e.get()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        logger.info("finished jobs test {}", (Object)this.strategy);
        this.executorService.shutdown();
        this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.executorService.isTerminated());
        logger.info("exiting test {}", (Object)this.strategy);
    }
}

