/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.api.service;

import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.query.QueryService;

public class ServiceRegistry {
    private static ServiceRegistry INSTANCE = new ServiceRegistry();
    protected volatile ConcurrentHashMap<String, Object> services = new ConcurrentHashMap();
    public static final String DEFINITION_SERVICE = DefinitionService.class.getSimpleName();
    public static final String DEPLOYMENT_SERVICE = DeploymentService.class.getSimpleName();
    public static final String PROCESS_SERVICE = ProcessService.class.getSimpleName();
    public static final String RUNTIME_DATA_SERVICE = RuntimeDataService.class.getSimpleName();
    public static final String USER_TASK_SERVICE = UserTaskService.class.getSimpleName();
    public static final String QUERY_SERVICE = QueryService.class.getSimpleName();
    public static final String PROCESS_ADMIN_SERVICE = ProcessInstanceAdminService.class.getSimpleName();
    public static final String MIGRATION_SERVICE = ProcessInstanceMigrationService.class.getSimpleName();
    public static final String USER_TASK_ADMIN_SERVICE = UserTaskAdminService.class.getSimpleName();
    public static final String CASE_SERVICE = "CaseService";
    public static final String CASE_RUNTIME_DATA_SERVICE = "CaseRuntimeDataService";

    private ServiceRegistry() {
    }

    public static ServiceRegistry get() {
        return INSTANCE;
    }

    public synchronized void register(String name, Object service) {
        this.services.put(name, service);
    }

    public synchronized void remove(String name) {
        this.services.remove(name);
    }

    public Object service(String name) {
        Object service = this.services.get(name);
        if (service == null) {
            throw new IllegalArgumentException("Service '" + name + "' not found");
        }
        return service;
    }

    public void clear() {
        this.services.clear();
    }
}

