/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.util.Collections;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.time.JobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.services.ejb.timer.EjbSchedulerService;
import org.junit.Assert;
import org.junit.Test;

public class EJBTimerJobNameTest {
    @Test
    public void testStartProcessJobContextUniqueJobNamesAmongSessions() {
        TimerManager.StartProcessJobContext ctxA = new TimerManager.StartProcessJobContext(new TimerInstance(), (Trigger)new IntervalTrigger(), "processId", Collections.emptyMap(), this.createRuntime(1L, "container-1"));
        TimerManager.StartProcessJobContext ctxB = new TimerManager.StartProcessJobContext(new TimerInstance(), (Trigger)new IntervalTrigger(), "processId", Collections.emptyMap(), this.createRuntime(2L, "container-2"));
        EjbSchedulerService service = new EjbSchedulerService();
        String jobNameA = service.getJobName((JobContext)ctxA, 1L);
        String jobNameB = service.getJobName((JobContext)ctxB, 1L);
        Assert.assertNotEquals((Object)jobNameA, (Object)jobNameB);
    }

    private InternalKnowledgeRuntime createRuntime(Long id, String containerId) {
        InternalKnowledgeBase kBase2 = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl knowledge = new StatefulKnowledgeSessionImpl(id.longValue(), kBase2);
        knowledge.getEnvironment().set("deploymentId", (Object)containerId);
        return knowledge;
    }
}

