/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.services.ejb.timer.EjbSchedulerService;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class EjbTimerServiceIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(EjbTimerServiceIntegrationTest.class);
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/timer-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.services.ejb.timer.test");
        war.addAsResource("BPMN2-TimerTask.bpmn2");
        war.addAsResource("HumanTaskWithDeadlines.bpmn");
        return war;
    }

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        properties.setProperty("krisv", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void cleanup() {
        this.cleanupSingletonSessionId();
    }

    @Test
    public void testProcessWithTimerOverEJBTimerService2SecDelay() throws InterruptedException {
        this.testProcessWithTimerOverEJBTimerService("2s");
    }

    @Test
    public void testProcessWithTimerOverEJBTimerService0SecDelay() throws InterruptedException {
        this.testProcessWithTimerOverEJBTimerService("0s");
    }

    public void testProcessWithTimerOverEJBTimerService(String delay) throws InterruptedException {
        this.cleanupSingletonSessionId();
        final ArrayList timerExecution = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerTask.bpmn2"), ResourceType.BPMN2).schedulerService((Object)new EjbSchedulerService()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                        if (event.getNodeInstance().getNodeName().equals("Event")) {
                            timerExecution.add(event.getNodeInstance().getNodeName());
                        }
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("x", delay);
        ProcessInstance instance = ksession.startProcess("IntermediateCatchEvent", parameters);
        Assert.assertNotNull((Object)instance);
        Thread.sleep(3000L);
        instance = ksession.getProcessInstance(instance.getId());
        Assert.assertNull((Object)instance);
        Assert.assertEquals((long)1L, (long)timerExecution.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testProcessWithTimerOverEJBTimerServiceCancelTimer() throws InterruptedException {
        this.cleanupSingletonSessionId();
        final ArrayList timerExecution = new ArrayList();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-TimerTask.bpmn2"), ResourceType.BPMN2).schedulerService((Object)new EjbSchedulerService()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

            public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
                List listeners = super.getProcessEventListeners(runtime);
                listeners.add(new DefaultProcessEventListener(){

                    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                        if (event.getNodeInstance().getNodeName().equals("Event")) {
                            timerExecution.add(event.getNodeInstance().getNodeName());
                        }
                    }
                });
                return listeners;
            }
        }).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance instance = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertNotNull((Object)instance);
        ksession.abortProcessInstance(instance.getId());
        instance = ksession.getProcessInstance(instance.getId());
        Assert.assertNull((Object)instance);
        Thread.sleep(3000L);
        Assert.assertEquals((long)0L, (long)timerExecution.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }

    @Test
    public void testProcessWithHTDeadlineTimerOverEJBTimerService() throws InterruptedException {
        this.cleanupSingletonSessionId();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"HumanTaskWithDeadlines.bpmn"), ResourceType.BPMN2).schedulerService((Object)new EjbSchedulerService()).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("htdeadlinetest");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        List krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)1L, (long)krisTasks.size());
        List johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        List maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        Thread.sleep(3000L);
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)johnTasks.get(0)).getId().longValue(), "john");
        Thread.sleep(2000L);
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        Thread.sleep(3000L);
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary");
        runtime.getTaskService().complete(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary", null);
        Thread.sleep(2000L);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        this.manager.close();
    }

    protected void cleanupSingletonSessionId() {
        File tempDir = new File(this.getLocation());
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }

    protected String getLocation() {
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        return location;
    }
}

