/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.JobNameHelper;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.jpa.TimerMappingInfo;
import org.jbpm.services.ejb.timer.EJBTimerScheduler;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;
import org.jbpm.services.ejb.timer.EjbTimerJob;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbSchedulerService
implements GlobalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(EjbSchedulerService.class);
    private static final Boolean TRANSACTIONAL = Boolean.parseBoolean(System.getProperty("org.jbpm.ejb.timer.tx", "true"));
    private AtomicLong idCounter = new AtomicLong();
    private TimerService globalTimerService;
    private EJBTimerScheduler scheduler;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor((GlobalSchedulerService)this);

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        long id = this.idCounter.getAndIncrement();
        String jobName = this.getJobName(ctx, id);
        EjbGlobalJobHandle jobHandle = new EjbGlobalJobHandle(id, jobName, ((GlobalTimerService)this.globalTimerService).getTimerServiceId());
        TimerJobInstance jobInstance = null;
        if (!this.isNewTimer(ctx)) {
            jobInstance = this.getTimerJobInstance(jobName);
            if (jobInstance == null) {
                jobInstance = this.scheduler.getTimerByName(jobName);
            }
            if (jobInstance != null) {
                return jobInstance.getJobHandle();
            }
        }
        jobInstance = this.globalTimerService.getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this.globalTimerService);
        jobHandle.setTimerJobInstance(jobInstance);
        this.interceptor.internalSchedule(jobInstance);
        return jobHandle;
    }

    public boolean removeJob(final JobHandle jobHandle) {
        String uuid = ((EjbGlobalJobHandle)jobHandle).getUuid();
        final Timer ejbTimer = this.getEjbTimer(this.getTimerMappinInfo(uuid));
        if (TRANSACTIONAL.booleanValue() && ejbTimer == null) {
            return false;
        }
        JtaTransactionManager tm = (JtaTransactionManager)TransactionManagerFactory.get().newTransactionManager();
        try {
            tm.registerTransactionSynchronization(new TransactionSynchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (status == 0) {
                        logger.debug("remove job {} after commited", (Object)jobHandle);
                        EjbSchedulerService.this.scheduler.removeJob(jobHandle, ejbTimer);
                    }
                }
            });
            logger.debug("register tx to remove job {}", (Object)jobHandle);
            return true;
        }
        catch (Exception e) {
            logger.debug("remove job {} outside tx", (Object)jobHandle);
            return this.scheduler.removeJob(jobHandle, ejbTimer);
        }
    }

    private TimerJobInstance getTimerJobInstance(String uuid) {
        return this.unwrapTimerJobInstance(this.getEjbTimer(this.getTimerMappinInfo(uuid)));
    }

    public TimerJobInstance getTimerJobInstance(long processInstanceId, long timerId) {
        return this.unwrapTimerJobInstance(this.getEjbTimer(this.getTimerMappinInfo(processInstanceId, timerId)));
    }

    private Timer getEjbTimer(TimerMappingInfo timerMappingInfo) {
        try {
            if (timerMappingInfo == null || timerMappingInfo.getInfo() == null) {
                return null;
            }
            byte[] data = timerMappingInfo.getInfo();
            return ((TimerHandle)new ObjectInputStream(new ByteArrayInputStream(data)).readObject()).getTimer();
        }
        catch (Exception e) {
            logger.warn("wast not able to deserialize info field from timer info for uuid");
            return null;
        }
    }

    private TimerMappingInfo getTimerMappinInfo(String uuid) {
        return this.getTimerMappingInfo(em -> em.createQuery("SELECT o FROM TimerMappingInfo o WHERE o.uuid = :uuid", TimerMappingInfo.class).setParameter("uuid", (Object)uuid).getResultList());
    }

    private TimerMappingInfo getTimerMappinInfo(long processInstanceId, long timerId) {
        return this.getTimerMappingInfo(em -> em.createQuery("SELECT o FROM TimerMappingInfo o WHERE o.timerId = :timerId AND o.processInstanceId = :processInstanceId", TimerMappingInfo.class).setParameter("processInstanceId", (Object)processInstanceId).setParameter("timerId", (Object)timerId).getResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerMappingInfo getTimerMappingInfo(Function<EntityManager, List<TimerMappingInfo>> func) {
        InternalRuntimeManager manager = ((GlobalTimerService)this.globalTimerService).getRuntimeManager();
        String pu = manager.getDeploymentDescriptor().getPersistenceUnit();
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(pu);
        try (EntityManager em = emf.createEntityManager();){
            List<TimerMappingInfo> info = func.apply(em);
            if (!info.isEmpty()) {
                TimerMappingInfo timerMappingInfo = info.get(0);
                return timerMappingInfo;
            }
            TimerMappingInfo timerMappingInfo = null;
            return timerMappingInfo;
        }
    }

    private TimerJobInstance unwrapTimerJobInstance(Timer timer) {
        try {
            if (timer == null) {
                return null;
            }
            Serializable info = timer.getInfo();
            EjbTimerJob job = (EjbTimerJob)info;
            TimerJobInstance handle = job.getTimerJobInstance();
            return handle;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void invalidate(JobHandle jobHandle) {
        this.scheduler.evictCache(jobHandle);
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.scheduler.internalSchedule(timerJobInstance);
    }

    public void initScheduler(TimerService timerService) {
        this.globalTimerService = timerService;
        try {
            this.scheduler = (EJBTimerScheduler)InitialContext.doLookup("java:module/EJBTimerScheduler");
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to find EJB scheduler for jBPM timer service", e);
        }
    }

    public void shutdown() {
    }

    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return new EjbGlobalJobHandle(-1L, this.getJobName((JobContext)ctx, -1L), ((GlobalTimerService)this.globalTimerService).getTimerServiceId());
    }

    public boolean isTransactional() {
        return TRANSACTIONAL;
    }

    public boolean retryEnabled() {
        return false;
    }

    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        return true;
    }

    protected String getJobName(JobContext ctx, long id) {
        return JobNameHelper.getJobName((JobContext)ctx, (long)id);
    }

    private boolean isNewTimer(JobContext ctx) {
        return ctx instanceof TimerManager.ProcessJobContext && ((TimerManager.ProcessJobContext)ctx).isNewTimer();
    }
}

