/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.timer;

import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.drools.core.time.JobHandle;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.persistence.timer.GlobalJpaTimerJobInstance;
import org.jbpm.services.ejb.timer.EJBTimerScheduler;
import org.jbpm.services.ejb.timer.EjbGlobalJobHandle;
import org.jbpm.services.ejb.timer.EjbTimerJob;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EJBTimerSchedulerTest {
    private Collection<Timer> timers = new ArrayList<Timer>();
    private Timer timer1 = (Timer)Mockito.mock(Timer.class);
    private EjbGlobalJobHandle ejbGlobalJobHandle1;
    private EJBTimerScheduler scheduler;

    @Before
    public void setup() {
        TimerService timerService = (TimerService)Mockito.mock(TimerService.class);
        Mockito.when((Object)timerService.getTimers()).thenReturn(this.timers);
        GlobalJpaTimerJobInstance timerJobInstance1 = (GlobalJpaTimerJobInstance)Mockito.mock(GlobalJpaTimerJobInstance.class);
        this.ejbGlobalJobHandle1 = new EjbGlobalJobHandle(1L, "test job", "test");
        this.ejbGlobalJobHandle1.setTimerJobInstance((TimerJobInstance)timerJobInstance1);
        Mockito.when((Object)timerJobInstance1.getJobHandle()).thenReturn((Object)this.ejbGlobalJobHandle1);
        Mockito.when((Object)this.timer1.getInfo()).thenReturn((Object)new EjbTimerJob((TimerJobInstance)timerJobInstance1));
        this.timers.add(this.timer1);
        this.scheduler = new EJBTimerScheduler();
        this.scheduler.setUseLocalCache(true);
        this.scheduler.timerService = timerService;
    }

    @Test
    public void testEjbTimerSchedulerTestOnTimerLoop() {
        TimerJobInstance jobInstance = this.scheduler.getTimerByName("not existing");
        Assert.assertNull((Object)jobInstance);
        jobInstance = this.scheduler.getTimerByName("not existing");
        Assert.assertNull((Object)jobInstance);
        jobInstance = this.scheduler.getTimerByName("test job");
        Assert.assertNotNull((Object)jobInstance);
        this.scheduler.removeJob((JobHandle)this.ejbGlobalJobHandle1, (Timer)null);
        this.timers.remove(this.timer1);
        jobInstance = this.scheduler.getTimerByName("test job");
        Assert.assertNull((Object)jobInstance);
    }

    @Test
    public void evictCacheForEjbTimerSchedulerTest() {
        TimerJobInstance jobInstance = this.scheduler.getTimerByName("test job");
        Assert.assertNotNull((Object)jobInstance);
        this.timers.remove(this.timer1);
        jobInstance = this.scheduler.getTimerByName("test job");
        Assert.assertNotNull((Object)jobInstance);
        this.scheduler.evictCache((JobHandle)this.ejbGlobalJobHandle1);
        jobInstance = this.scheduler.getTimerByName("test job");
        Assert.assertNull((Object)jobInstance);
    }
}

