/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.bpmn2.FlowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathContext {
    private List<FlowElement> pathElements = new ArrayList<FlowElement>();
    private Type type;
    private boolean canBeFinished = true;
    private boolean locked = false;
    private String id = String.valueOf(UUID.randomUUID());

    public PathContext() {
        this.setType(Type.ROOT);
    }

    public PathContext(Type type) {
        this.setType(type);
    }

    public void addPathElement(FlowElement element) {
        if (!this.locked) {
            this.pathElements.add(element);
        }
    }

    public List<FlowElement> getPathElements() {
        return this.pathElements;
    }

    public void setPathElements(List<FlowElement> pathElements) {
        this.pathElements = pathElements;
    }

    public PathContext cloneCurrent() {
        PathContext clone = new PathContext(Type.ACTIVE);
        clone.setCanBeFinished(this.isCanBeFinished());
        clone.setPathElements(new ArrayList<FlowElement>(this.getPathElements()));
        return clone;
    }

    public PathContext cloneGiven(PathContext toclone) {
        PathContext clone = new PathContext(Type.ACTIVE);
        clone.setCanBeFinished(toclone.isCanBeFinished());
        clone.setPathElements(new ArrayList<FlowElement>(toclone.getPathElements()));
        return clone;
    }

    public boolean isCanBeFinished() {
        return this.canBeFinished;
    }

    public void setCanBeFinished(boolean canBeFinished) {
        this.canBeFinished = canBeFinished;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getId() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ROOT,
        ACTIVE;

    }
}

